---
title: クッキー
page_id: "050.020"
---

## クッキー

クッキーは、キーと値のペアとしてブラウザ（PC）に保存された情報のことで、Webアプリ側とブラウザとで共有されるものです。いろいろと制約はあるのですが、ほぼ全てのブラウザで実装されている機能であり、前節で説明したとおりセッションを実現するために必要不可欠なものです。

当時のネットスケープコミュニケーションズ社によって提案され、今はRFCとして標準化されるまでに至っています。

## クッキーに文字列を保存する

クッキーは、最初にWebアプリによって作り出されます。クッキーの仕様に則り、HTTPレスポンスに対してキーと値のペアをを保存するのです。

アクションの中で、キーと値をペアにして次の関数を呼び出すことで、クッキーへ保存されます。

```c++
addCookie("key1", "Hello world.");
```

クッキーには有効期限を設定することができます。有効期限内であれば、HTTPリクエストに乗って、ブラウザから送られてきます。もし有効期限を過ぎたら、そのクッキーは自動的に消滅します（ブラウザが消してくれる）。有効期限は addCookie()関数の第３引数で指定します。詳細は、[APIリファレンス](http://treefrogframework.org/tf_doxygen/classTActionController.html){:target="_blank"}をご覧ください。

## クッキーから文字列を読み込む

HTTPリクエストに存在するクッキーの中から、キーを使ってその値を取り出す方法は次のとおりです。

```c++
QByteArray text = httpRequest().cookie("key1");
// text = "Hello world."
```
