---
title: JSON/XML Response
page_id: "050.050"
---

## JSON/XML Response

There are cases where, in order to provide information to an external application, data needs to be output in XML format or JSON. A case would be the Ajax applications.

## Send the Contents of the Model in JSON Format

If external applications use JavaScript, the JSON (JavaScript Object Notation) format is easy to handle. To deal with JSON in this framework, Qt version 5 or later is required.

Here is an example of sending a JSON object from the controller.

```c++
 Blog blog = Blog::get(10);
 renderJson(blog.toVariantMap());
```

That's all. The model that is generated by the generator, is provided by the toVariantMap() method to convert QVariantMap object itself. It's important to note that this method will convert all the properties a model has, therefore the method should be implemented separately for separate properties if there is information to be concealed.

Sending All Blog Objects in List Format

```
 renderJson( Blog::getAllJson() );
```

This is also simple! However, please note that if there are a large number of records in the blog database, results could be unexpected.

In addition to this, the following methods are available. Please check the [API reference](http://treefrogframework.org/tf_doxygen/classes.html){:target="_blank"} for this.

```c++
 bool renderJson(const QJsonDocument &document);
 bool renderJson(const QJsonObject &object);
 bool renderJson(const QJsonArray &array);
 bool renderJson(const QVariantMap &map);
 bool renderJson(const QVariantList &list);
 bool renderJson(const QStringList &list);
```

## Send the Contents of the Model in XML Format

The way to send the content of the model in XML format is not much different from the way we send in JSON format. Call one of the following methods in order to achieve this:

```c++
 bool renderXml(const QDomDocument &document);
 bool renderXml(const QVariantMap &map);
 bool renderXml(const QVariantList &list);
 bool renderXml(const QStringList &list);
```

If the input from the output of these does not suit your requirements, you can implement a new template. How to implement it is described in the [view chapter]({{ site.baseurl }}/en/user-guide/view/index.html){:target="_blank"} section, but don't forget that you only set the content type of the response in the controller.

```c++
 setContentType("text/xml")
```