---
title: 安全
page_id: "100.0"
---

## 安全

一旦你发布一个网站, 你必须理解它面对的风险挑战和设置安全监控. 应用的开发者必须小心地编程避免网页的漏洞. 你可以在互联网上找到详细的文章, 这是我不打算在这里深入介绍的原因.

因为Treefrog有一个内建的安全系统, 你正确使用它时可以建立一个安全的网站.

## SQL 注入保护

你也知道, SQL注入表示SQL语句构造的问题导致数据库可以被攻击或者错误的使用. Treefrog建议遵守下面的SQL注入监测:

* 使用ORM对象 => 可以在内部生成一个安全的SQL查询语句.
* 使用TSqlQuery占位符构建SQL语句 => 值会被自动转义处理.
* 通过字符串拼接构建SQL语句时, 字段名使用TSqlQuery::escapeIdentifier(), 值使用TSqlQuery::formatValue(). => 字段和值都实现了转义处理.

## 跨域脚本防范(CSRF)

如果网站的处理过程中有缺陷, 它可以允许包含恶意脚本, 如果发生了这种情况, 跨域脚本工具可以被使用. 为了防止这种情况, 你应该指定一个策略, 对于动态输出到视图(view)区域的所有值和属性都应该使用转义. 在Treefrog中, 以下这些已经完成:

* eh()方法和'<%= .. %>'符号应该用来输出值.

没有使用转义处理输出时需要特别消息, 这些输出是用echo()方法或者'<%== .. %>'符号.

基本上, 对于任何\<script\> .. \</script\> 元素的内容, 我建议不要根据外部输入动态地输出任何信息.

## CSRF保护

任何接受不验证用户请求的网站, 都有可能存在CSRF(跨域请求伪造)的漏洞. 如果一个HTTP请求已经被第三方篡改, 你必须废弃它.

要放置这个, 执行下面这两条.

* 对于表单上的信息, 仅接受Post方式的请求.
* 在表单中的信息项上放置一个难以预测的一排字母作为隐藏参数, 在收到后验证是否有效. => 通过使用formTag()方法创建的表单标签, 会自动创建一个隐藏参数.

如果隐藏参数是容易预测的, 跨域访问伪造(CSRF)保护就不够充分. 这个参数是一个使用Session的hash()函数转换得到字符串. 保密参数在*application.ini*配置文件中. 通过任何人都不知道*Session.Secret*值, 它就是一个难以猜测的字符串.

要打开跨域访问伪造(CSRF)保护, 你需要设置*application.ini*文件:

```
EnableCsrfProtectionModule=true
```

我建议你在开发应用的过程中关闭这个功能.

##### 概要:使用fromTag()方法生成表单标签.

## 会话劫持保护

当会话ID容易被猜测或者被偷, 欺骗行为是可能的. 这类欺骗行为的实施被称为会话劫持.

在Treefrog框架, 作为会话劫持的防御, 每次网站被访问时, 使用随机数和hash函数生成了一个新的合适长度的会话ID来避免被猜中. 通过这种方式, 对于一个提供了足够保护的常规网站来说, 会话是非常难猜中的.

虽然猜测一个会话ID是困难的, 一个比较严重的风险是网络上可能的窃听. 要防止这个, 通过方向代理(例如nginx或Apache)加密(SSL)通信通道是可能的.

##### 概要: 用SSL加密所有要处理重要信息的网站.