---
title: 介绍
page_id: "010.0"
---

## 介绍

### TreeFrog框架是什么

TreeFrog框架是一个全栈的网页应用框架. 框架由C++编写, 轻量(低资源需求)且高效运行.

基于减少C++框架开发成本的目的, 框架遵循惯例优先的原则. 配置文件被设计成尽可能小. 因为框架提供了自动生成模版系统(scaffolding), O/R映射(ORM)的代码, 开发者可以将关注点放在业务逻辑上.

### 跨平台
Treefrog框架是跨平台的. 它运行在Windows上, 也可以运行在类UNIX的操作系统上, 如macOS和Linux. 使用Windows的开源代码同样可以支持Linux. 网页应用同样可以运行在多个平台上, 仅需要简单的重新编译源码.

### 控制器

开发者可以很容易的获得HTTP请求/反馈, 以及HTTP会话中的数据. 此外, 框架还提供了一些非常有用的功能, 例如登录身份验证, 表单验证, 访问控制.
同时, 因为框架提供了一种机制(路由系统routing system)用来使控制器完成从请求的URL需要的操作(action)到控制器方法(method)的转换, 不再需要在配置文件中一条一条的写规则, 或者分配任何操作(action)请求.

### 视图

在视图层, 在Rails熟知的ERB格式可以被使用. C++代码<% ...%>可以嵌入到HTML文件中. 这意味着编写代码的方式可以非常类似于脚本语言.
框架同样提供了一种新的模版系统(Otama), 这种模版系统将界面逻辑从模版中完全分离出来. 通过编写少量的HTML, 模版可以描述C++编写的逻辑文件. 这样能够让后台的编程者和前台的界面设计者合作开发.

### 模型

在模型层, 提供了Sql对象(SqlObject), O/R 映射器(O/R 映射系统). 应用程序的开发人员因此可以关注与开发业务逻辑, 而不必写太多的SQL语句.
虽说如此, 如果在复杂的条件下使用数据, SQL语句也可以被直接使用. 通过使用占位符, SQL查询可以被简单的查询并且是安全的.
此外, 框架兼容所遇主流的数据库, 例如MySQL, PostgreSQL, SQLite, DB2, Oracle.

### 基于Qt

Qt和Treefrog框架是结合在一起使用的. 不仅Qt的图形界面(GUI)框架功能是强大的, Qt非图形界面的功能也非常好的. 通过组合核心模块容器类(core module container class), 网络(network), SQL, JSON, 单元测试(unit test)和元组对象(meta-object)的网页应用, 给应用开发者提供了非常方便的可用性功能.

### 开源

Treefrog框架是开源软件, 基于新BSD许可(3-clause BSD License).