---
title: 和反向代理服务器协同工作
page_id: "140.0"
---

## 和反向代理服务器协同工作

Treefrog框架提供另一个应用服务器(AP server)来返回每个请求动态创建的内容.前面已经提到, 应用服务器也可以作用网页服务器使用, 所以也可以处理静态的内容.作为网页服务器, 我们已经针对性的为它实现了一个函数,用来高速响应静态内容.

根据实际情况, 它适合于中小型的网页站点.然而, 当建立一个大型网页系统时, 为了实现稳定的运行和负载平衡, 使用网页服务器(反向代理)系统(例如*nginx*或*Apache*)就变得很有必要了.<br>
还有, 如果你想用压缩的响应和SSL, 你必须独立架设一个网页服务器.

##### 概要:对于大型的网站,架设网页服务器.

<div class="center aligned" markdown="1">

**服务端角色**

</div>

<div class="table-div" markdown="1">
| 服务器                     | 角色                                             |
|----------------------------|--------------------------------------------------|
| 网页服务器(反向代理)       | 负载均衡, 加密, 压缩, 缓存,发送静态内容等.       |
| 应用服务器(TreeFrog)       | 生成和发送动态内容(静态内容)                     |
| 数据库服务器 (RDB)         | 数据存储,保存                                    |

</div><br>

我不打算深入详述Apache和nginx的反向代理配置. 因为互联网上已经有大量的信息可以获得.<br> 
基本思路就是反向代理监听80端口, 然后将收到的请求转发到应用服务器. 当然, 应用服务器应该分配一个和其他服务不一样的端口. 使用*application.ini*文件的*ListenPort*参数设置端口号.

如果你在同一台机器上运行一台应用服务器和反向代理服务器. 你可以使用UNIX域嵌套字(domain socket)连接它们.使用UNIX域嵌套字(domain socket)的好处是, 它的负债比TCP 嵌套字要小, 和不能被外部的主机连接.这个可以让你感觉更安全一点.

要设定相应的UNIX域嵌套字(domain socket)应用, 设置ListenPort参数如下:

```
 ListenPort=unix:/tmp/foo
```

- 请按需更改这个文件名.
例如, 要使nginx反向代理到一个UNIX域嵌套字(domain socket), 增加下面的入口:

```
upstream backend {
    server unix:/tmp/foo;
}
server {
    listen 80;
    server_name localhost;
    location / {
        proxy_pass        http://backend;
    }
}
```

然后需要做的就是保存这些设置.<br>
启动应用服务器和网页服务器, 然后试着从浏览器访问它, 确保它们工作正常.如果工作不正常, 试着检查access log查找原因.