/**
 * This file is auto-generated by OpenOpenAI using OpenAI's OpenAPI spec as a
 * source of truth.
 *
 * DO NOT EDIT THIS FILE MANUALLY if you want your changes to persist.
 */
import { z } from '@hono/zod-openapi'

export const OrderSchema = z.enum(['asc', 'desc'])
export type Order = z.infer<typeof OrderSchema>

// One of `server_error` or `rate_limit_exceeded`.

export const CodeSchema = z.enum(['rate_limit_exceeded', 'server_error'])
export type Code = z.infer<typeof CodeSchema>

// The object type, which is always `thread.run.step``.

export const PurpleObjectSchema = z.literal('thread.run.step')
export type PurpleObject = z.infer<typeof PurpleObjectSchema>

// The status of the run step, which can be either `in_progress`, `cancelled`, `failed`,
// `completed`, or `expired`.

export const PurpleStatusSchema = z.enum([
  'cancelled',
  'completed',
  'expired',
  'failed',
  'in_progress'
])
export type PurpleStatus = z.infer<typeof PurpleStatusSchema>

// Always `logs`.
//
// Always `image`.

export const OutputTypeSchema = z.enum(['image', 'logs'])
export type OutputType = z.infer<typeof OutputTypeSchema>

// The type of tool call. This is always going to be `code_interpreter` for this type of
// tool call.
//
// The type of tool call. This is always going to be `retrieval` for this type of tool
// call.
//
// The type of tool call. This is always going to be `function` for this type of tool call.
//
// The type of tool being defined: `code_interpreter`
//
// The type of tool being defined: `retrieval`
//
// The type of tool being defined: `function`

export const ToolTypeSchema = z.enum([
  'code_interpreter',
  'function',
  'retrieval'
])
export type ToolType = z.infer<typeof ToolTypeSchema>

// Always `message_creation``.
//
// Always `tool_calls`.
//
// The type of run step, which can be either `message_creation` or `tool_calls`.

export const StepDetailsTypeSchema = z.enum(['message_creation', 'tool_calls'])
export type StepDetailsType = z.infer<typeof StepDetailsTypeSchema>

// The role of the entity that is creating the message. Currently only `user` is supported.

export const MessageRoleSchema = z.literal('user')
export type MessageRole = z.infer<typeof MessageRoleSchema>

// The object type, which is always `thread.run`.

export const FluffyObjectSchema = z.literal('thread.run')
export type FluffyObject = z.infer<typeof FluffyObjectSchema>

// The type of tool call the output is required for. For now, this is always `function`.

export const PurpleTypeSchema = z.literal('function')
export type PurpleType = z.infer<typeof PurpleTypeSchema>

// For now, this is always `submit_tool_outputs`.

export const RequiredActionTypeSchema = z.literal('submit_tool_outputs')
export type RequiredActionType = z.infer<typeof RequiredActionTypeSchema>

// The status of the run, which can be either `queued`, `in_progress`, `requires_action`,
// `cancelling`, `cancelled`, `failed`, `completed`, or `expired`.

export const FluffyStatusSchema = z.enum([
  'cancelled',
  'cancelling',
  'completed',
  'expired',
  'failed',
  'in_progress',
  'queued',
  'requires_action'
])
export type FluffyStatus = z.infer<typeof FluffyStatusSchema>

// The object type, which is always `assistant`.

export const TentacledObjectSchema = z.literal('assistant')
export type TentacledObject = z.infer<typeof TentacledObjectSchema>

// Always `file_citation`.
//
// Always `file_path`.

export const AnnotationTypeSchema = z.enum(['file_citation', 'file_path'])
export type AnnotationType = z.infer<typeof AnnotationTypeSchema>

// Always `image_file`.
//
// Always `text`.

export const ContentTypeSchema = z.enum(['image_file', 'text'])
export type ContentType = z.infer<typeof ContentTypeSchema>

// The object type, which is always `thread.message`.

export const StickyObjectSchema = z.literal('thread.message')
export type StickyObject = z.infer<typeof StickyObjectSchema>

// The entity that produced the message. One of `user` or `assistant`.

export const DatumRoleSchema = z.enum(['assistant', 'user'])
export type DatumRole = z.infer<typeof DatumRoleSchema>

// The object type, which is always `file`.

export const OpenAIFileObjectSchema = z.literal('file')
export type OpenAIFileObject = z.infer<typeof OpenAIFileObjectSchema>

// The intended purpose of the file. Supported values are `fine-tune`, `fine-tune-results`,
// `assistants`, and `assistants_output`.

export const OpenAIFilePurposeSchema = z.enum([
  'assistants',
  'assistants_output',
  'fine-tune',
  'fine-tune-results'
])
export type OpenAIFilePurpose = z.infer<typeof OpenAIFilePurposeSchema>

// Deprecated. The current status of the file, which can be either `uploaded`, `processed`,
// or `error`.

export const OpenAIFileStatusSchema = z.enum(['error', 'processed', 'uploaded'])
export type OpenAIFileStatus = z.infer<typeof OpenAIFileStatusSchema>

export const ListFilesResponseObjectSchema = z.literal('list')
export type ListFilesResponseObject = z.infer<
  typeof ListFilesResponseObjectSchema
>

// The object type, which is always `assistant.file`.

export const IndigoObjectSchema = z.literal('assistant.file')
export type IndigoObject = z.infer<typeof IndigoObjectSchema>

// The object type, which is always `thread.message.file`.

export const IndecentObjectSchema = z.literal('thread.message.file')
export type IndecentObject = z.infer<typeof IndecentObjectSchema>

// The intended purpose of the uploaded file.
//
// Use "fine-tune" for [Fine-tuning](/docs/api-reference/fine-tuning) and "assistants" for
// [Assistants](/docs/api-reference/assistants) and
// [Messages](/docs/api-reference/messages). This allows us to validate the format of the
// uploaded file is correct for fine-tuning.

export const CreateFileRequestPurposeSchema = z.enum([
  'assistants',
  'fine-tune'
])
export type CreateFileRequestPurpose = z.infer<
  typeof CreateFileRequestPurposeSchema
>

export const DeleteAssistantResponseObjectSchema =
  z.literal('assistant.deleted')
export type DeleteAssistantResponseObject = z.infer<
  typeof DeleteAssistantResponseObjectSchema
>

// The object type, which is always `thread`.

export const ThreadObjectSchema = z.literal('thread')
export type ThreadObject = z.infer<typeof ThreadObjectSchema>

export const DeleteThreadResponseObjectSchema = z.literal('thread.deleted')
export type DeleteThreadResponseObject = z.infer<
  typeof DeleteThreadResponseObjectSchema
>

export const DeleteAssistantFileResponseObjectSchema = z.literal(
  'assistant.file.deleted'
)
export type DeleteAssistantFileResponseObject = z.infer<
  typeof DeleteAssistantFileResponseObjectSchema
>

export const DeleteAssistantFileResponseSchema = z.object({
  deleted: z.boolean(),
  id: z.string(),
  object: DeleteAssistantFileResponseObjectSchema
})
export type DeleteAssistantFileResponse = z.infer<
  typeof DeleteAssistantFileResponseSchema
>

export const CreateAssistantFileRequestSchema = z.object({
  file_id: z.string()
})
export type CreateAssistantFileRequest = z.infer<
  typeof CreateAssistantFileRequestSchema
>

export const ToolOutputSchema = z.object({
  output: z.string().optional(),
  tool_call_id: z.string().optional()
})
export type ToolOutput = z.infer<typeof ToolOutputSchema>

export const SubmitToolOutputsRunRequestSchema = z.object({
  tool_outputs: z.array(ToolOutputSchema)
})
export type SubmitToolOutputsRunRequest = z.infer<
  typeof SubmitToolOutputsRunRequestSchema
>

export const ModifyRunRequestSchema = z.object({
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional()
})
export type ModifyRunRequest = z.infer<typeof ModifyRunRequestSchema>

export const ModifyMessageRequestSchema = z.object({
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional()
})
export type ModifyMessageRequest = z.infer<typeof ModifyMessageRequestSchema>

export const DeleteThreadResponseSchema = z.object({
  deleted: z.boolean(),
  id: z.string(),
  object: DeleteThreadResponseObjectSchema
})
export type DeleteThreadResponse = z.infer<typeof DeleteThreadResponseSchema>

export const ModifyThreadRequestSchema = z.object({
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional()
})
export type ModifyThreadRequest = z.infer<typeof ModifyThreadRequestSchema>

export const ThreadSchema = z.object({
  created_at: z.number(),
  id: z.string(),
  metadata: z.record(z.string(), z.any()),
  object: ThreadObjectSchema
})
export type Thread = z.infer<typeof ThreadSchema>

export const DeleteAssistantResponseSchema = z.object({
  deleted: z.boolean(),
  id: z.string(),
  object: DeleteAssistantResponseObjectSchema
})
export type DeleteAssistantResponse = z.infer<
  typeof DeleteAssistantResponseSchema
>

export const DeleteFileResponseSchema = z.object({
  deleted: z.boolean(),
  id: z.string(),
  object: OpenAIFileObjectSchema
})
export type DeleteFileResponse = z.infer<typeof DeleteFileResponseSchema>

export const CreateFileRequestSchema = z.object({
  file: z.any(),
  purpose: CreateFileRequestPurposeSchema
})
export type CreateFileRequest = z.infer<typeof CreateFileRequestSchema>

export const MessageFileObjectSchema = z.object({
  created_at: z.number(),
  id: z.string(),
  message_id: z.string(),
  object: IndecentObjectSchema
})
export type MessageFileObject = z.infer<typeof MessageFileObjectSchema>

export const ListMessageFilesResponseClassSchema = z.object({
  data: z.array(MessageFileObjectSchema),
  first_id: z.string(),
  has_more: z.boolean(),
  last_id: z.string(),
  object: z.string(),
  items: z.any()
})
export type ListMessageFilesResponseClass = z.infer<
  typeof ListMessageFilesResponseClassSchema
>

export const AssistantFileObjectSchema = z.object({
  assistant_id: z.string(),
  created_at: z.number(),
  id: z.string(),
  object: IndigoObjectSchema
})
export type AssistantFileObject = z.infer<typeof AssistantFileObjectSchema>

export const ListAssistantFilesResponseClassSchema = z.object({
  data: z.array(AssistantFileObjectSchema),
  first_id: z.string(),
  has_more: z.boolean(),
  last_id: z.string(),
  object: z.string(),
  items: z.any()
})
export type ListAssistantFilesResponseClass = z.infer<
  typeof ListAssistantFilesResponseClassSchema
>

export const OpenAIFileClassSchema = z.object({
  bytes: z.number(),
  created_at: z.number(),
  filename: z.string(),
  id: z.string(),
  object: OpenAIFileObjectSchema,
  purpose: OpenAIFilePurposeSchema,
  status: OpenAIFileStatusSchema,
  status_details: z.string().optional()
})
export type OpenAIFileClass = z.infer<typeof OpenAIFileClassSchema>

export const ListFilesResponseSchema = z.object({
  data: z.array(
    z.union([
      z.array(z.any()),
      z.boolean(),
      OpenAIFileClassSchema,
      z.number(),
      z.number(),
      z.null(),
      z.string()
    ])
  ),
  object: ListFilesResponseObjectSchema
})
export type ListFilesResponse = z.infer<typeof ListFilesResponseSchema>

export const IndecentFunctionObjectSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: z.record(z.string(), z.any())
})
export type IndecentFunctionObject = z.infer<
  typeof IndecentFunctionObjectSchema
>

export const CreateRunRequestToolSchema = z.object({
  type: ToolTypeSchema,
  function: IndecentFunctionObjectSchema.optional()
})
export type CreateRunRequestTool = z.infer<typeof CreateRunRequestToolSchema>

export const CreateRunRequestSchema = z.object({
  assistant_id: z.string(),
  instructions: z.string().optional(),
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional(),
  model: z.string().optional(),
  tools: z.array(CreateRunRequestToolSchema).optional()
})
export type CreateRunRequest = z.infer<typeof CreateRunRequestSchema>

export const FilePathSchema = z.object({
  file_id: z.string()
})
export type FilePath = z.infer<typeof FilePathSchema>

export const FileCitationSchema = z.object({
  file_id: z.string(),
  quote: z.string()
})
export type FileCitation = z.infer<typeof FileCitationSchema>

export const MessageContentTextAnnotationsFileObjectSchema = z.object({
  end_index: z.number(),
  file_citation: FileCitationSchema.optional(),
  start_index: z.number(),
  text: z.string(),
  type: AnnotationTypeSchema,
  file_path: FilePathSchema.optional()
})
export type MessageContentTextAnnotationsFileObject = z.infer<
  typeof MessageContentTextAnnotationsFileObjectSchema
>

export const TextSchema = z.object({
  annotations: z.array(MessageContentTextAnnotationsFileObjectSchema),
  value: z.string()
})
export type Text = z.infer<typeof TextSchema>

export const ImageFileSchema = z.object({
  file_id: z.string()
})
export type ImageFile = z.infer<typeof ImageFileSchema>

export const MessageContentObjectSchema = z.object({
  image_file: ImageFileSchema.optional(),
  type: ContentTypeSchema,
  text: TextSchema.optional()
})
export type MessageContentObject = z.infer<typeof MessageContentObjectSchema>

export const MessageObjectSchema = z.object({
  assistant_id: z.string(),
  content: z.array(MessageContentObjectSchema),
  created_at: z.number(),
  file_ids: z.array(z.string()),
  id: z.string(),
  metadata: z.record(z.string(), z.any()),
  object: StickyObjectSchema,
  role: DatumRoleSchema,
  run_id: z.string(),
  thread_id: z.string()
})
export type MessageObject = z.infer<typeof MessageObjectSchema>

export const ListMessagesResponseClassSchema = z.object({
  data: z.array(MessageObjectSchema),
  first_id: z.string(),
  has_more: z.boolean(),
  last_id: z.string(),
  object: z.string()
})
export type ListMessagesResponseClass = z.infer<
  typeof ListMessagesResponseClassSchema
>

export const IndigoFunctionObjectSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: z.record(z.string(), z.any())
})
export type IndigoFunctionObject = z.infer<typeof IndigoFunctionObjectSchema>

export const ModifyAssistantRequestToolSchema = z.object({
  type: ToolTypeSchema,
  function: IndigoFunctionObjectSchema.optional()
})
export type ModifyAssistantRequestTool = z.infer<
  typeof ModifyAssistantRequestToolSchema
>

export const ModifyAssistantRequestSchema = z.object({
  description: z.string().optional(),
  file_ids: z.array(z.string()).optional(),
  instructions: z.string().optional(),
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional(),
  model: z.string().optional(),
  name: z.string().optional(),
  tools: z.array(ModifyAssistantRequestToolSchema).optional()
})
export type ModifyAssistantRequest = z.infer<
  typeof ModifyAssistantRequestSchema
>

export const StickyFunctionObjectSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: z.record(z.string(), z.any())
})
export type StickyFunctionObject = z.infer<typeof StickyFunctionObjectSchema>

export const CreateAssistantRequestToolSchema = z.object({
  type: ToolTypeSchema,
  function: StickyFunctionObjectSchema.optional()
})
export type CreateAssistantRequestTool = z.infer<
  typeof CreateAssistantRequestToolSchema
>

export const CreateAssistantRequestSchema = z.object({
  description: z.string().optional(),
  file_ids: z.array(z.string()).optional(),
  instructions: z.string().optional(),
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional(),
  model: z.string(),
  name: z.string().optional(),
  tools: z.array(CreateAssistantRequestToolSchema).optional()
})
export type CreateAssistantRequest = z.infer<
  typeof CreateAssistantRequestSchema
>

export const TentacledFunctionObjectSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: z.record(z.string(), z.any())
})
export type TentacledFunctionObject = z.infer<
  typeof TentacledFunctionObjectSchema
>

export const FluffyAssistantToolsSchema = z.object({
  type: ToolTypeSchema,
  function: TentacledFunctionObjectSchema.optional()
})
export type FluffyAssistantTools = z.infer<typeof FluffyAssistantToolsSchema>

export const AssistantObjectSchema = z.object({
  created_at: z.number(),
  description: z.string(),
  file_ids: z.array(z.string()),
  id: z.string(),
  instructions: z.string(),
  metadata: z.record(z.string(), z.any()),
  model: z.string(),
  name: z.string(),
  object: TentacledObjectSchema,
  tools: z.array(FluffyAssistantToolsSchema)
})
export type AssistantObject = z.infer<typeof AssistantObjectSchema>

export const ListAssistantsResponseSchema = z.object({
  data: z.array(AssistantObjectSchema),
  first_id: z.string(),
  has_more: z.boolean(),
  last_id: z.string(),
  object: z.string()
})
export type ListAssistantsResponse = z.infer<
  typeof ListAssistantsResponseSchema
>

export const FluffyFunctionObjectSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: z.record(z.string(), z.any())
})
export type FluffyFunctionObject = z.infer<typeof FluffyFunctionObjectSchema>

export const PurpleAssistantToolsSchema = z.object({
  type: ToolTypeSchema,
  function: FluffyFunctionObjectSchema.optional()
})
export type PurpleAssistantTools = z.infer<typeof PurpleAssistantToolsSchema>

export const FluffyFunctionSchema = z.object({
  arguments: z.string(),
  name: z.string()
})
export type FluffyFunction = z.infer<typeof FluffyFunctionSchema>

export const RunToolCallObjectSchema = z.object({
  function: FluffyFunctionSchema,
  id: z.string(),
  type: PurpleTypeSchema
})
export type RunToolCallObject = z.infer<typeof RunToolCallObjectSchema>

export const SubmitToolOutputsSchema = z.object({
  tool_calls: z.array(RunToolCallObjectSchema)
})
export type SubmitToolOutputs = z.infer<typeof SubmitToolOutputsSchema>

export const RequiredActionSchema = z.object({
  submit_tool_outputs: SubmitToolOutputsSchema,
  type: RequiredActionTypeSchema
})
export type RequiredAction = z.infer<typeof RequiredActionSchema>

export const FluffyLastErrorSchema = z.object({
  code: CodeSchema,
  message: z.string()
})
export type FluffyLastError = z.infer<typeof FluffyLastErrorSchema>

export const RunObjectSchema = z.object({
  assistant_id: z.string(),
  cancelled_at: z.number(),
  completed_at: z.number(),
  created_at: z.number(),
  expires_at: z.number(),
  failed_at: z.number(),
  file_ids: z.array(z.string()),
  id: z.string(),
  instructions: z.string(),
  last_error: FluffyLastErrorSchema,
  metadata: z.record(z.string(), z.any()),
  model: z.string(),
  object: FluffyObjectSchema,
  required_action: RequiredActionSchema,
  started_at: z.number(),
  status: FluffyStatusSchema,
  thread_id: z.string(),
  tools: z.array(PurpleAssistantToolsSchema)
})
export type RunObject = z.infer<typeof RunObjectSchema>

export const ListRunsResponseSchema = z.object({
  data: z.array(RunObjectSchema),
  first_id: z.string(),
  has_more: z.boolean(),
  last_id: z.string(),
  object: z.string()
})
export type ListRunsResponse = z.infer<typeof ListRunsResponseSchema>

export const PurpleFunctionObjectSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  parameters: z.record(z.string(), z.any())
})
export type PurpleFunctionObject = z.infer<typeof PurpleFunctionObjectSchema>

export const CreateThreadAndRunRequestToolSchema = z.object({
  type: ToolTypeSchema,
  function: PurpleFunctionObjectSchema.optional()
})
export type CreateThreadAndRunRequestTool = z.infer<
  typeof CreateThreadAndRunRequestToolSchema
>

export const CreateMessageRequestSchema = z.object({
  content: z.string(),
  file_ids: z.array(z.string()).optional(),
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional(),
  role: MessageRoleSchema
})
export type CreateMessageRequest = z.infer<typeof CreateMessageRequestSchema>

export const CreateThreadRequestSchema = z.object({
  messages: z.array(CreateMessageRequestSchema).optional(),
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional()
})
export type CreateThreadRequest = z.infer<typeof CreateThreadRequestSchema>

export const CreateThreadAndRunRequestSchema = z.object({
  assistant_id: z.string(),
  instructions: z.string().optional(),
  metadata: z.union([z.record(z.string(), z.any()), z.null()]).optional(),
  model: z.string().optional(),
  thread: CreateThreadRequestSchema.optional(),
  tools: z.array(CreateThreadAndRunRequestToolSchema).optional()
})
export type CreateThreadAndRunRequest = z.infer<
  typeof CreateThreadAndRunRequestSchema
>

export const PurpleFunctionSchema = z.object({
  arguments: z.string(),
  name: z.string(),
  output: z.string()
})
export type PurpleFunction = z.infer<typeof PurpleFunctionSchema>

export const ImageSchema = z.object({
  file_id: z.string()
})
export type Image = z.infer<typeof ImageSchema>

export const RunStepDetailsToolCallsCodeOutputObjectSchema = z.object({
  logs: z.string().optional(),
  type: OutputTypeSchema,
  image: ImageSchema.optional()
})
export type RunStepDetailsToolCallsCodeOutputObject = z.infer<
  typeof RunStepDetailsToolCallsCodeOutputObjectSchema
>

export const CodeInterpreterSchema = z.object({
  input: z.string(),
  outputs: z.array(RunStepDetailsToolCallsCodeOutputObjectSchema)
})
export type CodeInterpreter = z.infer<typeof CodeInterpreterSchema>

export const RunStepDetailsToolCallsObjectSchema = z.object({
  code_interpreter: CodeInterpreterSchema.optional(),
  id: z.string(),
  type: ToolTypeSchema,
  retrieval: z.union([z.record(z.string(), z.any()), z.null()]).optional(),
  function: PurpleFunctionSchema.optional()
})
export type RunStepDetailsToolCallsObject = z.infer<
  typeof RunStepDetailsToolCallsObjectSchema
>

export const MessageCreationSchema = z.object({
  message_id: z.string()
})
export type MessageCreation = z.infer<typeof MessageCreationSchema>

export const StepDetailsSchema = z.object({
  message_creation: MessageCreationSchema.optional(),
  type: StepDetailsTypeSchema,
  tool_calls: z.array(RunStepDetailsToolCallsObjectSchema).optional()
})
export type StepDetails = z.infer<typeof StepDetailsSchema>

export const PurpleLastErrorSchema = z.object({
  code: CodeSchema,
  message: z.string()
})
export type PurpleLastError = z.infer<typeof PurpleLastErrorSchema>

export const RunStepObjectSchema = z.object({
  assistant_id: z.string(),
  cancelled_at: z.number(),
  completed_at: z.number(),
  created_at: z.number(),
  expired_at: z.number(),
  failed_at: z.number(),
  id: z.string(),
  last_error: PurpleLastErrorSchema,
  metadata: z.record(z.string(), z.any()),
  object: PurpleObjectSchema,
  run_id: z.string(),
  status: PurpleStatusSchema,
  step_details: StepDetailsSchema,
  thread_id: z.string(),
  type: StepDetailsTypeSchema
})
export type RunStepObject = z.infer<typeof RunStepObjectSchema>

export const ListRunStepsResponseClassSchema = z.object({
  data: z.array(RunStepObjectSchema),
  first_id: z.string(),
  has_more: z.boolean(),
  last_id: z.string(),
  object: z.string()
})
export type ListRunStepsResponseClass = z.infer<
  typeof ListRunStepsResponseClassSchema
>

export const GetMessageFileParamsPathClassSchema = z.object({
  file_id: z.string(),
  message_id: z.string(),
  thread_id: z.string()
})
export type GetMessageFileParamsPathClass = z.infer<
  typeof GetMessageFileParamsPathClassSchema
>

export const ListMessageFilesParamsQueryClassSchema = z.object({
  after: z.string().optional(),
  before: z.string().optional(),
  limit: z.string().optional(),
  order: OrderSchema.optional()
})
export type ListMessageFilesParamsQueryClass = z.infer<
  typeof ListMessageFilesParamsQueryClassSchema
>

export const ListMessageFilesParamsPathClassSchema = z.object({
  message_id: z.string(),
  thread_id: z.string()
})
export type ListMessageFilesParamsPathClass = z.infer<
  typeof ListMessageFilesParamsPathClassSchema
>

export const DeleteAssistantFileParamsPathClassSchema = z.object({
  assistant_id: z.string(),
  file_id: z.string()
})
export type DeleteAssistantFileParamsPathClass = z.infer<
  typeof DeleteAssistantFileParamsPathClassSchema
>

export const GetAssistantFileParamsPathClassSchema = z.object({
  assistant_id: z.string(),
  file_id: z.string()
})
export type GetAssistantFileParamsPathClass = z.infer<
  typeof GetAssistantFileParamsPathClassSchema
>

export const CreateAssistantFileParamsPathClassSchema = z.object({
  assistant_id: z.string()
})
export type CreateAssistantFileParamsPathClass = z.infer<
  typeof CreateAssistantFileParamsPathClassSchema
>

export const ListAssistantFilesParamsQueryClassSchema = z.object({
  after: z.string().optional(),
  before: z.string().optional(),
  limit: z.string().optional(),
  order: OrderSchema.optional()
})
export type ListAssistantFilesParamsQueryClass = z.infer<
  typeof ListAssistantFilesParamsQueryClassSchema
>

export const ListAssistantFilesParamsPathClassSchema = z.object({
  assistant_id: z.string()
})
export type ListAssistantFilesParamsPathClass = z.infer<
  typeof ListAssistantFilesParamsPathClassSchema
>

export const GetRunStepParamsPathClassSchema = z.object({
  run_id: z.string(),
  step_id: z.string(),
  thread_id: z.string()
})
export type GetRunStepParamsPathClass = z.infer<
  typeof GetRunStepParamsPathClassSchema
>

export const ListRunStepsParamsQueryClassSchema = z.object({
  after: z.string().optional(),
  before: z.string().optional(),
  limit: z.string().optional(),
  order: OrderSchema.optional()
})
export type ListRunStepsParamsQueryClass = z.infer<
  typeof ListRunStepsParamsQueryClassSchema
>

export const ListRunStepsParamsPathClassSchema = z.object({
  run_id: z.string(),
  thread_id: z.string()
})
export type ListRunStepsParamsPathClass = z.infer<
  typeof ListRunStepsParamsPathClassSchema
>

export const CancelRunParamsPathClassSchema = z.object({
  run_id: z.string(),
  thread_id: z.string()
})
export type CancelRunParamsPathClass = z.infer<
  typeof CancelRunParamsPathClassSchema
>

export const SubmitToolOuputsToRunParamsPathClassSchema = z.object({
  run_id: z.string(),
  thread_id: z.string()
})
export type SubmitToolOuputsToRunParamsPathClass = z.infer<
  typeof SubmitToolOuputsToRunParamsPathClassSchema
>

export const ModifyRunParamsPathClassSchema = z.object({
  run_id: z.string(),
  thread_id: z.string()
})
export type ModifyRunParamsPathClass = z.infer<
  typeof ModifyRunParamsPathClassSchema
>

export const GetRunParamsPathClassSchema = z.object({
  run_id: z.string(),
  thread_id: z.string()
})
export type GetRunParamsPathClass = z.infer<typeof GetRunParamsPathClassSchema>

export const CreateRunParamsPathClassSchema = z.object({
  thread_id: z.string()
})
export type CreateRunParamsPathClass = z.infer<
  typeof CreateRunParamsPathClassSchema
>

export const ListRunsParamsQueryClassSchema = z.object({
  after: z.string().optional(),
  before: z.string().optional(),
  limit: z.string().optional(),
  order: OrderSchema.optional()
})
export type ListRunsParamsQueryClass = z.infer<
  typeof ListRunsParamsQueryClassSchema
>

export const ListRunsParamsPathClassSchema = z.object({
  thread_id: z.string()
})
export type ListRunsParamsPathClass = z.infer<
  typeof ListRunsParamsPathClassSchema
>

export const ModifyMessageParamsPathClassSchema = z.object({
  message_id: z.string(),
  thread_id: z.string()
})
export type ModifyMessageParamsPathClass = z.infer<
  typeof ModifyMessageParamsPathClassSchema
>

export const GetMessageParamsPathClassSchema = z.object({
  message_id: z.string(),
  thread_id: z.string()
})
export type GetMessageParamsPathClass = z.infer<
  typeof GetMessageParamsPathClassSchema
>

export const CreateMessageParamsPathClassSchema = z.object({
  thread_id: z.string()
})
export type CreateMessageParamsPathClass = z.infer<
  typeof CreateMessageParamsPathClassSchema
>

export const ListMessagesParamsQueryClassSchema = z.object({
  after: z.string().optional(),
  before: z.string().optional(),
  limit: z.string().optional(),
  order: OrderSchema.optional()
})
export type ListMessagesParamsQueryClass = z.infer<
  typeof ListMessagesParamsQueryClassSchema
>

export const ListMessagesParamsPathClassSchema = z.object({
  thread_id: z.string()
})
export type ListMessagesParamsPathClass = z.infer<
  typeof ListMessagesParamsPathClassSchema
>

export const DeleteThreadParamsPathClassSchema = z.object({
  thread_id: z.string()
})
export type DeleteThreadParamsPathClass = z.infer<
  typeof DeleteThreadParamsPathClassSchema
>

export const ModifyThreadParamsPathClassSchema = z.object({
  thread_id: z.string()
})
export type ModifyThreadParamsPathClass = z.infer<
  typeof ModifyThreadParamsPathClassSchema
>

export const GetThreadParamsPathClassSchema = z.object({
  thread_id: z.string()
})
export type GetThreadParamsPathClass = z.infer<
  typeof GetThreadParamsPathClassSchema
>

export const DeleteAssistantParamsPathClassSchema = z.object({
  assistant_id: z.string()
})
export type DeleteAssistantParamsPathClass = z.infer<
  typeof DeleteAssistantParamsPathClassSchema
>

export const ModifyAssistantParamsPathClassSchema = z.object({
  assistant_id: z.string()
})
export type ModifyAssistantParamsPathClass = z.infer<
  typeof ModifyAssistantParamsPathClassSchema
>

export const GetAssistantParamsPathClassSchema = z.object({
  assistant_id: z.string()
})
export type GetAssistantParamsPathClass = z.infer<
  typeof GetAssistantParamsPathClassSchema
>

export const ListAssistantsParamsQueryClassSchema = z.object({
  after: z.string().optional(),
  before: z.string().optional(),
  limit: z.string().optional(),
  order: OrderSchema.optional()
})
export type ListAssistantsParamsQueryClass = z.infer<
  typeof ListAssistantsParamsQueryClassSchema
>

export const DownloadFileParamsPathClassSchema = z.object({
  file_id: z.string()
})
export type DownloadFileParamsPathClass = z.infer<
  typeof DownloadFileParamsPathClassSchema
>

export const RetrieveFileParamsPathClassSchema = z.object({
  file_id: z.string()
})
export type RetrieveFileParamsPathClass = z.infer<
  typeof RetrieveFileParamsPathClassSchema
>

export const DeleteFileParamsPathClassSchema = z.object({
  file_id: z.string()
})
export type DeleteFileParamsPathClass = z.infer<
  typeof DeleteFileParamsPathClassSchema
>

export const ListFilesParamsQueryClassSchema = z.object({
  purpose: z.string().optional()
})
export type ListFilesParamsQueryClass = z.infer<
  typeof ListFilesParamsQueryClassSchema
>
