vcpkg_from_github(
  OUT_SOURCE_PATH SOURCE_PATH
  REPO lifting-bits/gap
  REF a7ceecc118410f11b0c904b88a5ccfd6221f434b
  SHA512 20b72abb4a5c6bb97a218ea0c9492c1e70ba158c4a351656fec29141ed15dd17cdbececa0b31ebb7d4d44af6db69be4c4d40ef9ebd19dd8ac3a085e2e5ca15a4
  HEAD_REF main
)

vcpkg_check_features(
    OUT_FEATURE_OPTIONS FEATURE_OPTIONS
    FEATURES
        sarif GAP_ENABLE_SARIF
)

if (DEFINED CMAKE_PREFIX_PATH)
    set(VCPKG_CMAKE_PREFIX_PATH ${CMAKE_PREFIX_PATH})
else()
    set(VCPKG_CMAKE_PREFIX_PATH $ENV{CMAKE_PREFIX_PATH})
endif()

vcpkg_cmake_configure(
  SOURCE_PATH "${SOURCE_PATH}"
  OPTIONS
    -DGAP_ENABLE_COROUTINES=ON
    -DGAP_ENABLE_MLIR=ON
    -DGAP_ENABLE_TESTING=OFF
    -DGAP_INSTALL=ON
    -DGAP_ENABLE_WARNINGS=OFF
    -DCMAKE_PREFIX_PATH=${VCPKG_CMAKE_PREFIX_PATH}
    ${FEATURE_OPTIONS}
)

vcpkg_cmake_install()
vcpkg_cmake_config_fixup(
  PACKAGE_NAME "gap"
  CONFIG_PATH lib/cmake/gap
)

file(
  INSTALL "${SOURCE_PATH}/LICENSE"
  DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}"
  RENAME copyright
)

file(
  REMOVE_RECURSE
  "${CURRENT_PACKAGES_DIR}/debug/share"
  "${CURRENT_PACKAGES_DIR}/debug/include"
)