---
title: "Traefik Migration Documentation"
description: "Learn the steps needed to migrate to new Traefik Proxy v3 versions. Read the technical documentation."
---

# Migration: Steps needed between the versions

## v3.0 to v3.1

### Kubernetes Provider RBACs

Starting with v3.1, the Kubernetes Providers now use the [EndpointSlices API](https://kubernetes.io/docs/concepts/services-networking/endpoint-slices/) (Kubernetes >=v1.21) to discover service endpoint addresses.
It also brings NodePort load-balancing which requires Nodes resources lookup.

Therefore, in the corresponding RBACs (see [KubernetesIngress](../routing/providers/kubernetes-ingress.md#configuration-example), [KubernetesCRD](../reference/dynamic-configuration/kubernetes-crd.md#rbac), and [KubernetesGateway](../reference/dynamic-configuration/kubernetes-gateway-rbac.yml) provider RBACs):

- the `endpoints` right has to be removed and the following `endpointslices` right has to be added:

```yaml
  ... 
  - apiGroups:
      - discovery.k8s.io
    resources:
      - endpointslices
    verbs:
      - list
      - watch
  ...
```

- the `nodes` right has to be added:

```yaml
  ...
  - apiGroups:
      - ""
    resources:
      - nodes
    verbs:
      - get
      - list
      - watch
  ...
```

#### Gateway API: KubernetesGateway Provider

In v3.1, the KubernetesGateway Provider is no longer an experimental feature.
It can be enabled without the associated `experimental.kubernetesgateway` option, which is now deprecated.

??? example "An example of the experimental `kubernetesgateway` option"

    ```yaml tab="File (YAML)"
    experimental:
      kubernetesgateway: true
    ```

    ```toml tab="File (TOML)"
    [experimental]
        kubernetesgateway=true
    ```

    ```bash tab="CLI"
    --experimental.kubernetesgateway=true
    ```

##### Remediation

The `kubernetesgateway` option should be removed from the experimental section of the static configuration.
To configure `kubernetesgateway`, please check out the [KubernetesGateway Provider documentation](../providers/kubernetes-gateway.md).

## v3.1.0 to v3.1.1

### IngressClass Lookup

The Kubernetes Ingress provider option `disableIngressClassLookup` has been deprecated in v3.1.1, and will be removed in the next major version.
Please use the `disableClusterScopeResources` option instead to avoid cluster scope resources discovery (IngressClass, Nodes).

## v3.1 to v3.2

### Kubernetes CRD Provider

Starting with v3.2, the CRDs has been updated on [TraefikService](../routing/services#mirroring-service) (PR [#11032](https://github.com/traefik/traefik/pull/11032)) and on [RateLimit](../middlewares/http/ratelimit) & [InFlightReq](../middlewares/http/inflightreq) middlewares (PR [#9747](https://github.com/traefik/traefik/pull/9747)).

This update adds only new optional fields.
CRDs can be updated with this command:

```shell
kubectl apply -f https://raw.githubusercontent.com/traefik/traefik/v3.2/docs/content/reference/dynamic-configuration/kubernetes-crd-definition-v1.yml
```

### Kubernetes Gateway Provider Standard Channel

Starting with v3.2, the Kubernetes Gateway Provider now supports [GRPCRoute](https://gateway-api.sigs.k8s.io/api-types/grpcroute/).

Therefore, in the corresponding RBACs (see [KubernetesGateway](../reference/dynamic-configuration/kubernetes-gateway.md#rbac) provider RBACs),
the `grcroutes` and `grpcroutes/status` rights have to be added.

```yaml
  ...
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - grpcroutes
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - grpcroutes/status
    verbs:
      - update
  ...
```

### Kubernetes Gateway Provider Experimental Channel

!!! warning "Breaking changes"

    Because of a breaking change introduced in Kubernetes Gateway [v1.2.0-rc1](https://github.com/kubernetes-sigs/gateway-api/releases/tag/v1.2.0-rc1),
    Traefik v3.2 only supports Kubernetes Gateway v1.2.x when experimental channel features are enabled.

Starting with v3.2, the Kubernetes Gateway Provider now supports [BackendTLSPolicy](https://gateway-api.sigs.k8s.io/api-types/backendtlspolicy/).

Therefore, in the corresponding RBACs (see [KubernetesGateway](../reference/dynamic-configuration/kubernetes-gateway.md#rbac) provider RBACs),
the `configmaps`, `backendtlspolicies` and `backendtlspolicies/status` rights have to be added.

```yaml
  ...
  - apiGroups:
      - ""
    resources:
      - configmaps
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - backendtlspolicies
    verbs:
      - get
      - list
      - watch
  - apiGroups:
      - gateway.networking.k8s.io
    resources:
      - backendtlspolicies/status
    verbs:
      - update
  ...
```
