<p align="center"><img src="../../static/logo-small.png" alt="MarkText" width="100" height="100"></p>

<h1 align="center">MarkText</h1>

<div align="center">
  <a href="https://twitter.com/intent/tweet?via=marktextme&url=https://github.com/marktext/marktext/&text=What%20do%20you%20want%20to%20say%20to%20app?&hashtags=happyMarkText">
    <img src="https://img.shields.io/twitter/url/https/github.com/marktext/marktext.svg?style=for-the-badge" alt="twitter">
  </a>
</div>
<div align="center">
  <strong>:high_brightness: 次世代マークダウンエディタ :crescent_moon:</strong><br>
  シンプルでエレガントなマークダウンエディタ: スピードと使いやすさをあなたに<br>
  <sub>Linux・macOS・Windowsで使用可能</sub>
</div>

<br>

<div align="center">
  <!-- Version -->
  <a href="https://marktext.github.io/website">
    <img src="https://badge.fury.io/gh/jocs%2Fmarktext.svg" alt="website">
  </a>
  <!-- License -->
  <a href="LICENSE">
    <img src="https://img.shields.io/github/license/marktext/marktext.svg" alt="LICENSE">
  </a>
  <!-- Build Status -->
  <a href="https://travis-ci.org/marktext/marktext/">
    <img src="https://travis-ci.org/marktext/marktext.svg?branch=master" alt="build">
  </a>
  <a href="https://ci.appveyor.com/project/marktext/marktext/branch/master">
    <img src="https://ci.appveyor.com/api/projects/status/l4gxgydj0i95hmxg/branch/master?svg=true" alt="build">
  </a>
  <!-- Downloads total -->
  <a href="https://github.com/marktext/marktext/releases">
    <img src="https://img.shields.io/github/downloads/marktext/marktext/total.svg" alt="total download">
  </a>
  <!-- Downloads latest release -->
  <a href="https://github.com/marktext/marktext/releases/latest">
    <img src="https://img.shields.io/github/downloads/marktext/marktext/v0.17.1/total.svg" alt="latest download">
  </a>
  <!-- sponsors -->
  <a href="https://opencollective.com/marktext">
    <img src="https://opencollective.com/marktext/tiers/silver-sponsors/badge.svg?label=SilverSponsors&color=brightgreen" alt="sponsors">
  </a>
</div>

<div align="center">
  <h3>
    <a href="https://github.com/marktext/marktext">
      ウェブサイト
    </a>
    <span> | </span>
    <a href="#features">
      特徴
    </a>
    <span> | </span>
    <a href="#download">
      ダウンロード
    </a>
    <span> | </span>
    <a href="#development">
      開発
    </a>
    <span> | </span>
    <a href="#contribution">
      コントリビューション
    </a>
  </h3>
</div>

<div align="center">
  <sub>多言語版:</sub>
  <a href="../../README.md">
    <span>:uk:</span>
  </a>
  <a href="zh_cn.md">
    <span>:cn:</span>
  </a>
  <a href="pl.md">
    <span>:poland:</span>
  </a>
  <a href="french.md">
    <span>:fr:</span>
  </a>
  <a href="tr.md">
    <span>:tr:</span>
  </a>
  <a href="spanish.md">
    <span>:es:</span>
  </a>
  <a href="pt.md">
    <span>:portugal:</span>
  </a>
  <a href="ko.md">
    <span>:kr:</span>
  </a>
</div>

<div align="center">
  <sub>This Markdown editor that could. Built with ❤︎ by
    <a href="https://github.com/Jocs">Jocs</a> and
    <a href="https://github.com/marktext/marktext/graphs/contributors">
      contributors
    </a>
  </sub>
</div>

<br />

<h2 align="center">MarkTextへの支援</h2>

MarkTextは、MITライセンスのオープンソースプロジェクトであり、Githubリリースページからいつでも無料で最新のMarkTextをダウンロードできます。MarkTextはまだ開発中のソフトウェアであり、開発を続けるためにはスポンサーからのご支援が必要です。どうかMarkTextへのご支援をよろしくお願い申し上げます。

- Patreonを介して継続的ご支援をいただける場合は[こちら](https://www.patreon.com/ranluo)から、また、一時寄付金をいただける場合は[こちら](https://github.com/Jocs/sponsor.me)からお願いいたします。
- Open Collectiveを介してご支援をいただける場合は[こちら](https://opencollective.com/marktext)をご利用ください。

##### PatreonとOpen Collectiveの違い

Patreonを介した寄付は、MarkTextの開発および維持を行っているLuo Ran (@jocs)に直接届きます。Open Collectiveを介した寄付は、その額や出資者が公開されます。すべての出資金はMarkTextの開発、維持、オンラインおよびオフラインでの活動、そしてその他の必要なリソースの入手に使われます。PatreonかOpen Collectiveかに関わらず、すべての出資者のお名前もしくは会社のロゴは、MarkTextの公式サイトおよびReadmeに掲載いたします。

**Platinum Sponsors**

<a href="https://opencollective.com/marktext#platinum-sponsors">
 <img src="https://opencollective.com/marktext/tiers/platinum-sponsors.svg?avatarHeight=36&width=600">
</a>

**Gold Sponsors**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/gold-sponsors.svg?avatarHeight=36&width=600">
</a>

**Silver Sponsors**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/silver-sponsors.svg?avatarHeight=36&width=600">
</a>

**Bronze Sponsors**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/bronze-sponsors.svg?avatarHeight=36&width=600">
</a>

**Backers**

<a href="https://opencollective.com/marktext#backers">
  <img src="https://opencollective.com/marktext/tiers/backer.svg?avatarHeight=36&width=600">
</a>

## スクリーンショット

![](../../docs/marktext.png?raw=true)

<h2 id="features">特徴</h2>

- WYSIWYGなリアルタイムプレビューと、執筆に没頭できるクリーンでシンプルなインターフェース
- [CommonMark Spec](https://spec.commonmark.org/0.29/)と[GitHub Flavored Markdown Spec](https://github.github.com/gfm/)、および一部の[Pandoc Markdown](https://pandoc.org/MANUAL.html#pandocs-markdown)をサポート
- KaTeXを用いた数式表示、Front matterや絵文字が使用可能
- 段落とインラインショートカットを利用することで編集効率を向上
- **HTML**ファイルと**PDF**ファイルを出力可能
- **Cadmium Light**, **Material Dark**など様々なテーマ
- 選べる編集モード: **Source Code mode**, **Typewriter mode**, **Focus mode**

<h4 align="center">:crescent_moon:テーマ:high_brightness:</h4>

| Cadmium Light                                           | Dark                                                  |
|:-------------------------------------------------------:|:-----------------------------------------------------:|
| ![](../../docs/themeImages/cadmium-light.png?raw=true)  | ![](../../docs/themeImages/dark.png?raw=true)         |
| Graphite Light                                          | Materal Dark                                          |
| ![](../../docs/themeImages/graphite-light.png?raw=true) | ![](../../docs/themeImages/materal-dark.png?raw=true) |
| Ulysses Light                                           | One Dark                                              |
| ![](../../docs/themeImages/ulysses-light.png?raw=true)  | ![](../../docs/themeImages/one-dark.png?raw=true)     |

<h4 align="center">:smile_cat:編集モード:dog:</h4>

| Source Code                | Typewriter                     | Focus                     |
|:--------------------------:|:------------------------------:|:-------------------------:|
| ![](../../docs/source.gif) | ![](../../docs/typewriter.gif) | ![](../../docs/focus.gif) |

## 開発の意図

1. 私は書くことが好きです。これまでに沢山のマークダウンエディタを使ってきましたが、まだ私の要望を完璧に満たすものを見つけられていません。致命的なバグに執筆を邪魔されたくないのです。**MarkText**はページのレンダリングに仮想DOMを用いることで効率を向上させ、さらにオープンソースで提供しました。
2. 上記の通り、**MarkText**はオープンソースなので、誰でもソースコードをコントリビュートすることで開発に参加し、**MarkText** をポピュラーなマークダウンエディタにしていくことができます。
3. 特徴的な機能を備えたマークダウンエディタは既に沢山ありますが、全てのマークダウンユーザーの要望を満たすのは難しいです。まだまだ未熟ですが、**MarkText** がマークダウンユーザーの要望を可能な限り叶えられるエディタになることを願っています。

<h2 id="download">ダウンロード</h2>

![platform](https://img.shields.io/static/v1.svg?label=Platform&message=Linux-64%20|%20macOS-64%20|%20Win-32%20|%20Win-64&style=for-the-badge)

| ![]( https://github.com/ryanoasis/nerd-fonts/wiki/screenshots/v1.0.x/mac-pass-sm.png)                                                                                                             | ![]( https://github.com/ryanoasis/nerd-fonts/wiki/screenshots/v1.0.x/windows-pass-sm.png)                                                                                                                     | ![]( https://github.com/ryanoasis/nerd-fonts/wiki/screenshots/v1.0.x/linux-pass-sm.png)                                                                                                                                   |
|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-x64.dmg.svg)](https://github.com/marktext/marktext/releases/download/v0.17.1/marktext-x64.dmg) | [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-setup.exe.svg)](https://github.com/marktext/marktext/releases/download/v0.17.1/marktext-setup.exe) | [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-x86_64.AppImage.svg)](https://github.com/marktext/marktext/releases/download/v0.17.1/marktext-x86_64.AppImage) |

このバージョンでの新着情報をご確認いただくには、[CHANGELOG](../../.github/CHANGELOG.md)を参照してください。

#### macOS

最新のMarkText(`marktext-%version%.dmg`)を[リリースページ](https://github.com/marktext/marktext/releases/latest)からダウンロードするか、[**homebrew cask**](https://github.com/caskroom/homebrew-cask)を用いてインストールしてください。Homebrew-Caskを使うためには、[Homebrew](https://brew.sh/)がインストールされている必要があります。

```bash
brew install --cask mark-text
```

#### Windows

MarkTextをダウンロードして、セットアップウィザード(`marktext-setup-%version%.exe`)を介してインストールしてください。インストールの際、ユーザごとにインストールするか、グローバルにインストールするかを選択してください。

#### Linux

[Linux installation instructions](../../docs/LINUX.md)を参照してください。

#### その他

Linux、macOSおよびWindows用の全てのバイナリは、[リリースページ](https://github.com/marktext/marktext/releases/latest)からダウンロードできます。お使いのシステムで使用可能なソフトウェアがリリースページ内に見つからない場合は、[issue](https://github.com/marktext/marktext/issues) を作成してお知らせいただけると幸いです。

<h2 id="development">開発</h2>

**MarkText** を自前でビルドしたい場合は、[build instructions](../../docs/dev/BUILD.md)を参照してください。

- [User documentation](../../docs/README.md)
- [Developer documentation](../../docs/dev/README.md)

**MarkText**に関するご質問がありましたら、フォーマットを参考にissueを作成してください。もちろんプルリクエストを直接提出して頂いても構いません。ご協力ありがとうございます。

## インテグレーション

- [Alfred Workflow](http://www.packal.org/workflow/mark-text): macOS向けのアプリであるAlfred Workflowです。Alfredを起動して、"mt"コマンドを入力することでファイルやフォルダをMarkTextで開きます。

<h2 id="contribution">コントリビューション</h2>

MarkTextは開発の真っ最中です、プルリクエストを作成する場合は事前に [Contributing Guide](../../CONTRIBUTING.md) をご確認ください。MarkTextに追加したい新機能がある場合は、 [roadmap](https://github.com/marktext/marktext/projects)を参考にしてissueを作成してください。

## コントリビューター

MarkTextにコントリビュートしてくださった [[コントリビューター](https://github.com/marktext/marktext/graphs/contributors)] の皆さんに感謝を申し上げます。

MarkTextのロゴをデザインしてくださった @[Yasujizr](https://github.com/Yasujizr) に感謝を申し上げます。

<a href="https://github.com/marktext/marktext/graphs/contributors"><img src="https://opencollective.com/marktext/contributors.svg?width=890" /></a>

## ライセンス

[**MIT**](../../LICENSE).

[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2Fmarktext%2Fmarktext.svg?type=large)](https://app.fossa.io/projects/git%2Bgithub.com%2Fmarktext%2Fmarktext?ref=badge_large)
