package security.packaging

import com.intellij.openapi.progress.ProgressIndicator
import com.intellij.openapi.progress.ProgressManager
import com.intellij.openapi.progress.Task.Backgroundable
import com.intellij.openapi.project.Project
import com.intellij.openapi.startup.ProjectActivity

class PythonPackageVulnerabilityStartupTask : ProjectActivity {
    override suspend fun execute(project: Project) {
        if (project.isDisposed) return

        ProgressManager.getInstance().run(object : Backgroundable(project, "Checking Python packages for known CVEs", false) {
            override fun run(indicator: ProgressIndicator) {
                PyPackageSecurityScan.checkPackages(project)
            }
        })
    }
}