# XML200

Enabling the allow_dotted_names option allows intruders to access your module’s global variables and may allow intruders to execute arbitrary code on your machine. 

## Example

```python
from xmlrpc.server import SimpleXMLRPCServer


with SimpleXMLRPCServer(('0.0.0.0', 8000),) as server:
    class MyFuncs:
        def mul(self, x, y):
            return x * y

    server.register_instance(MyFuncs(), allow_dotted_names=True)  # This is bad!

    # Run the server's main loop
    server.serve_forever()
```

## Fixes

* Disable this option
* Only use within a secure, local network

## See Also

* [Official Documentation](https://docs.python.org/3/library/xmlrpc.server.html#module-xmlrpc.server)