# TRY100

Use of a `try` ... `except` block where the except block does not contain anything other than comments and a `pass` statement is considered bad security practice.

Whilst an attacker may be trying to exploit exceptions in your code, you should, at the very least, log these exceptions.

Some runtime errors that may be caused by insufficient permissions should not be allowed to continue control flow, and should stop execution of the program.

This will only apply to the generic explicit `Exception` except type, or an empty except type.

## Example 

This is bad

```python
try:
    do_things
except Exception:
    # do nothing!
    pass
```

This is also bad

```python
try:
    do_things
except:
    # do nothing!
    pass
```

## Fixes

* Fix the reason why the exception occurs
* Consider using a `raise from` statement
* Add logging to the except block
