#STR100

String format function allows access to protected attributes, is someone are able to manage the format string can access to sensible information.


##Example
```python
CONFIG = {
    'SECRET_KEY': 'super secret key'
}

class Event(object):
    def __init__(self, id, level, message):
        self.id = id
        self.level = level
        self.message = message

def format_event(format_string, event):
    return format_string.format(event=event)
```
If `format_event` is executed with `format_string = "{event.__init__.__globals__[CONFIG][SECRET_KEY]}"`,
the secret_key will be read


##Fixes

* Replace using string.Template
* Replace using CustomFormatter(string.Formatter) overwriting the get_field function and disable the access to protected attributes (all with _ at the beginning)


##See Also
* [Be Careful with Python's New-Style String Format](https://lucumr.pocoo.org/2016/12/29/careful-with-str-format/)
* [Jinja 2.8.1 Security Release](https://palletsprojects.com/blog/jinja-281-released/)
