# SQL100

Looks for SQL injection by Python string formatting methods. Includes:

- Use of "f-string"
- Use for string.format()
- Use of `%` formatting

Will look for formatted string literals that start with:

- `INSERT INTO `
- `DELETE FROM`
- `ALTER TABLE `
- `DROP DATABASE `
- `CREATE DATABASE `

It will also look for strings that start with `SELECT ` and contain ` FROM `, as well as strings that start with ` UPDATE ` and contain ` SET `. 

Check is case-insensitive.

This check does not verify that the input is sanitized.

## Examples

Each of the following expressions would trigger a warning for this check:

```python
id = get_id()  # Could be a SQLi response..

query1 = f"SELECT * FROM users WHERE id = {id}"

query2 = "SELECT * FROM users WHERE id = {0}" % id

query3 = "SELECT * FROM users WHERE id = {0}".format(id)

query4 = f"UPDATE users SET is_admin = 1 WHERE id = {id}"

query5 = f"DELETE FROM users WHERE id = {id}"

query6 = f"INSERT INTO users (id) VALUES ( id = {id} )"

query7 = f"SELECT * FROM users WHERE id = {id}"
```

## Fixes

Apply input validation and escaping.

## See Also

[RealPython.com article on SQL injection](https://realpython.com/prevent-python-sql-injection/)