# SH100

Potential shell injection with unescaped input.

Will inspect the arguments to a standard library function that starts a subshell, and check that it doesn't purely contain string literals, or input escaped from `shlex.quote`

## APIs

Python has many ways to execute local commands, either as a process or using a shell.

Each of these could be vulnerable to injection techniques if the input is not escaped correctly.

- `os.system`
- `os.popen` 
- `os.popen2`
- `os.popen3`
- `os.popen4`
- `posix.system`
- `posix.popen` ...
- `popen2.popen2`
- `popen2.popen3`
- `popen2.popen4` 
- `popen2.Popen3`
- `popen2.Popen4`
- `commands.getoutut`
- `commands.getstatusoutput`

Note that many of these APIs are deprecated, but this check will work on older Python scripts.

## Example

```python
import os
os.system("ls {0}".format(x))  # this is bad!
```

Some APIs accept a list as the first argument, in which case that is inspected

```python
import popen2
popen2.popen3(["ls", x])
```

## Notes

* String literals are ok
* Lists of string literals are ok
* Call expressions or reference expressions are treated as "unsafe" unless escaped

## Quick Fixes

* [Shell Escape Fixer](../fixes/shellescapefixer.md)

## See Also

- [PR100](PR100.md) : Subprocess check



