# PR100

Calling `subprocess.call`, `subprocess.run`, or `subprocess.Popen` with `shell=True` can leave the host shell open to local code execution or remote code execution attacks.

## Example

```python
import subprocess
ret = subprocess.call(['ps', opt], shell=True)
```

```python
import subprocess
ret = subprocess.run(['ps', opt], shell=True)
```

```python
import subprocess
ret = subprocess.Popen(['ps', opt], shell=True)
```

## Notes

* String literals are ok
* Lists of string literals are ok
* Call expressions or reference expressions are treated as "unsafe" unless escaped

## Quick Fixes

* [Shell Escape Fixer](../fixes/shellescapefixer.md)

## Fixes

Only use `shell=True` if absolutely required, then use `shlex.quote` surrounding any input, e.g.

```python
import subprocess
import shlex
ret = subprocess.call(['ps', shlex.quote(opt)], shell=True)
```

## See Also

* [Subprocess Security Considerations](https://docs.python.org/3/library/subprocess.html#security-considerations)