# PAR101

Unquoted inputs to paramiko `exec_command()` can leave the remote host vulnerable to shell injection.

Applies to :

* `SSHClient.exec_command()`
* `Channel.exec_command()`

## Notes

* String literals are ok
* Call expressions or reference expressions are treated as "unsafe" unless escaped

## Quick Fixes

* [Shell Escape Fixer](../fixes/shellescapefixer.md)

## Fixes

Use `shlex.quote` surrounding any input, e.g.

```python
import paramiko
import shlex

client = paramiko.SSHClient(...)
ret = client.exec_command(shlex.quote(input))
```
