# PAR100

Host key inspection bypass using the `paramiko` SSH library.

The paramiko library will automatically reject unknown host keys on connection.
This can be disabled by calling the `set_missing_host_key_policy()` method on a client instance. 

This practice is discouraged, as an attacker could be using DNS injection, or another technique, such as IP spoofing to trick the client into connecting
to a different server.

## Example

```python
import paramiko

client = paramiko.client.SSHClient()
client.set_missing_host_key_policy(paramiko.client.AutoAddPolicy)
```

## See Also

* [Missing host key policy documentation](http://docs.paramiko.org/en/stable/api/client.html#paramiko.client.MissingHostKeyPolicy)