# NET100

An IPv4 unspecified address, "0.0.0.0", or an IPv6 unspecified address "::" inside a `bind()` call.
This implies attempt to bind all network interfaces.

Unspecified address literals are:
- `0.0.0.0`
- `::`
- `0:0:0:0:0:0:0:0`

## Example

```python
import socket

# create an INET, STREAMing socket
serversocket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
# bind the socket to a public host, and a well-known port
serversocket.bind(("0.0.0.0", 80))
# become a server socket
serversocket.listen(5)
```

## See Also 

* [NIST documentation](https://nvd.nist.gov/vuln/detail/CVE-2018-1281)
