# MK100

By default, Mako will not sanitize or escape input to templates.

This leaves rendered templates open to XSS and other vulnerabilities.

Mako offers the ability to sanitize with filters. However, no filters are applied by default.

## Example

This flaw applies to templates constructed generically:

```python
from mako.template import Template
t = Template("<html><body> Hello ${ person }</body></html>")
t.render(person="<script type='javascript'>alert('I am an XSS flaw!')</script>")
```

## Quick Fixes

* [Mako HTML escape fixer](../fixes/makohtmlescape.md)

## Fixes

* Set `default_filters=['h']` on the `Template` constructor, or
* Use the `${ variable | h }` filter inline for every variable

## See Also

* [Official Documentation](https://docs.makotemplates.org/en/latest/filtering.html)