# JJ100

By default, Jinja 2 will not sanitize or escape input to templates.

This leaves rendered templates open to XSS and other vulnerabilities.

Jinja offers the ability to sanitize with the `autoescape` argument on the `Environment` initializer, however this is `False` by default.

## Example

This flaw applies to templates constructed generically:

```python
from jinja2 import Template
t = Template("<html><body> Hello {{person}}</body></html>")
t.render(person="<script type='javascript'>alert('I am an XSS flaw!')</script>")
```

And those fetched from an environment:

```python
from jinja2 import Environment, PackageLoader
env = Environment(
    loader=PackageLoader('yourapplication', 'templates'),
)
template = env.get_template('mytemplate.html')
template.render(person="<script type='javascript'>alert('I am an XSS flaw!')</script>")
```

## Quick Fixes

* [Jinja2 unconditional autoescape fixer](../fixes/jinja2unconditional.md)

## Fixes

* Set `autoescape=True` on the `Environment` or `Template` constructor, or
* Set `autoescape=select_autoescape(['html', 'xml'])` (or one of `html`, `xml`, )

## See Also

* [Official Documentation](https://jinja.palletsprojects.com/en/2.10.x/api/#autoescaping)