# HL101

MD5, SHA-1, RIPEMD-160, Whirlpool and the SHA-256 / SHA-512 hash algorithms all vulnerable to length-extension attacks and should not be used for obfuscating or protecting data without HMAC.

Length extension attacks allow an attacker to construct the `H(secret|message|append)` given only `H(secret|message)` and the length of `secret|message`. The attack uses the output hash to reconstruct the internal state of the hash function. From there, it is trivial to feed the hash function the data to be appended and output the new hash.

## Examples

The following examples would raise a warning:

```python
import hashlib
hashlib.new('sha256')
```

```python
import hashlib
hashlib.whirlpool()
```

## Fix

Use another hashing algorithm, e.g. blake2

## See Also

* [About Length Extension Attacks](https://blog.skullsecurity.org/2012/everything-you-need-to-know-about-hash-length-extension-attacks)
* [Proof of Concept](https://github.com/amlweems/hexpand)
