# HL100

MD4, MD5, SHA, and SHA1 hashing algorithms should not be used for obfuscating or protecting data as they are cryptographically weak (have collisions).

## Examples

The following examples would raise a warning:

```python
import hashlib
hashlib.new('sha1')
```

```python
import hashlib
hashlib.sha1()
```

## Fix

Use another hashing algorithm, e.g. blake2

## See Also

* [Hashlib Documentation](https://docs.python.org/3/library/hashlib.html)