# DJG301

Django permission required mixin for a class-based-view must be the **first** base class. If not, the logic can silently be bypassed.

## Fixes

Good :

```python
class MyView(PermissionRequiredMixin, View):
    permission_required = 'polls.add_choice'

```

Bad :

```python
class MyView(View, PermissionRequiredMixin):
    permission_required = 'polls.add_choice'

```

## See Also

- [DJG300](DJG300.md)
- [documentation](https://docs.djangoproject.com/en/3.0/topics/auth/default/#the-permissionrequiredmixin-mixin)