# DJG300

Django permission required mixin for a class-based-view must have either a class property `permission_required`, or a method `has_permission()`.

If neither exist, the view will (silently) allow anyone to access it.

## Fixes

Add either property or method to the view:

```python
class MyView(PermissionRequiredMixin, View):
    permission_required = 'polls.add_choice'

```

## See Also

- [DJG301](DJG301.md)
- [documentation](https://docs.djangoproject.com/en/3.0/topics/auth/default/#the-permissionrequiredmixin-mixin)



