# DJG103

This check looks for ways that Django SQL Injection protection is being bypassed in the `extra()` query set function, by using quoted parameters.

This check will inspect any string literal within the keyword-arguments:

* "where", "select", "tables", "order_by", "params"

## Example

In this example, the value of the othercol is vulnerable to SQL injection:

```python
qs.extra(
    select={'val': "select col from sometable where othercol = '%s'"},
    select_params=(someparam,),
)
```

This would also apply to the where argument:

```python
MyDataModel.objects.extra(where=['headline="%s"'], params=['Lennon'])
```

## Fixes

Remove the quotations from the string values:

```python
MyDataModel.objects.extra(where=['headline=%s'], params=['Lennon'])
```

## See Also

* [Official Documentation](https://docs.djangoproject.com/en/3.0/ref/models/querysets/#extra)
