# DJG102

Using safe strings bypasses the Django XSS protection.

If you are bypassing it because you're trying to create HTML tags, use [format_html()](https://docs.djangoproject.com/en/stable/ref/utils/#django.utils.html.format_html) instead.

Checks for Django 1.1, 2 and 3 safe string types:

* `SafeString`
* `SafeBytes`
* `SafeText`
* `SafeUnicode`
* `mark_safe`

As the use of this function may be intentional, it is a weak warning by default.

## Example

```python
from django.utils.safestring import mark_safe

mystr = '<b>Hello World</b>'
mystr = mark_safe(mystr)
```

## Fixes

* Use [format_html()](https://docs.djangoproject.com/en/stable/ref/utils/#django.utils.html.format_html) instead.

## See Also

* [Official Documentation](https://docs.djangoproject.com/en/stable/ref/utils/#module-django.utils.safestring)