# AST100

Issues a weak warning by default when an `assert` statement is used in a file that is not clearly a test.

In production environments, the `python -O` optimization flag is often used, which bypasses assert statements.

## Example

```python
def foo(request, user):
   assert user.is_admin, “user does not have access”
   # secure code...
```

If you execute Python with `-O`, the assert statement will become a noop and the check for permissions will be skipped.

## Fixes

* Do not use asserts for anything other than a debug guide, and if used, they should be within a test
