/*******************************************************************************
 * Copyright 2021 See AUTHORS file.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.github.tommyettinger.textra;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.github.tommyettinger.textra.Font.FontFamily;

public class FontFamilySkinTest extends InputAdapter implements ApplicationListener {
	FWSkin skin;
	Stage stage;

	@Override
	public void create () {
		skin = new FWSkin(Gdx.files.internal("shadeui/uiskin.json"));
		final FontFamily family = new FontFamily(skin);
		
		stage = new Stage(new ScreenViewport());
		Gdx.input.setInputProcessor(stage);

		Table root = new Table();
		root.setFillParent(true);
		stage.addActor(root);
		
		TextraLabel textraLabel = new TextraLabel("Default-font, [@font-button]font-button, [@font-label]font-label, [@font-title]font-title", family.connected[0]);
		root.add(textraLabel);
		
		for (String name : family.fontAliases.keys()) {
			System.out.println("name = " + name);
		}
	}

	@Override
	public void render () {
		ScreenUtils.clear(0.2f, 0.2f, 0.2f, 1);
		
		stage.act(Math.min(Gdx.graphics.getDeltaTime(), 1 / 30f));
		stage.draw();
	}

	@Override
	public void pause() {

	}

	@Override
	public void resume() {

	}

	@Override
	public void resize (int width, int height) {
		stage.getViewport().update(width, height, true);
		skin.resizeDistanceFields(width, height, stage.getViewport());
	}

	@Override
	public void dispose () {
		stage.dispose();
		skin.dispose();
	}

	public static void main(String[] args){
		Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
		config.setTitle("FontFamilySkin test");
		config.setWindowedMode(640, 540);
		config.disableAudio(true);
		config.useVsync(true);
		config.setForegroundFPS(0);
		new Lwjgl3Application(new FontFamilySkinTest(), config);
	}

}
