# 权限

本前端项目里需要用到权限控制的地方有两个：

    1. 路由页面的跳转
       源码位于 `@/router/guardian/accessControl.js`，再说明一点，不需要登录的路由也不需要进行权限控制
    
    2. 按钮
       一般使用 `v-if` 或者 `render` 做，尽量不使用 `display: none`，如果不得已那么需要在按钮方法里控制

项目使用基于资源url的形式来实现权限控制，说白点就是用户的所有操作都可以用一个url来标识。

鉴权方法为 `@/util/auth.js #auth`。

### 鉴权前的准备工作

登陆成功时，后台返回用户所拥有的资源，构造出用户的权限树。
之后用户在进入系统的任意一个需要登录才可访问的路由时，会向后台获取所有的资源，构造出总权限树（同时渲染菜单）。

### 鉴权流程

1. 如果用户是 `admin` 身份，那么直接放行。

2. 如果访问的 `url` 不在总权限树内，说明该操作无需权限，放行。

3. 如果访问的 `url` 在用户的权限树内，说明有权限，放行。

4. 否则拦截，如果是在路由的拦截器中则会跳转至403页面。

此流程与后端的流程行为一致。当然前端的权限控制只是过滤一小部分，对接口的过滤工作还是得由后端完成。

### 如何移除权限控制？

前端的权限控制的方法全在 `@/util/auth.js` 里面，哪里引入就改哪里，粗暴点直接让 `# auth` 方法返回true就完事了。
后端的权限控制由拦截器实现，同样的改造原理，easy啦。

### 为什么不是RBAC？

首先只有两种情况前端会用RBAC：

**1. 角色固定**：

比如接口管理平台YAPI，角色就是固定的那三四个，前端可以直接写死，这种是最最适合的。

**2. 角色不固定，但是后端可以返回角色-资源的映射表：**

映射表规定了页面上所有的资源（路由页面、数据接口、按钮等等）被哪些角色所拥有。
这样只需要凭一个用户的角色就能控制资源的访问，但是绝大部分开源的纯vue管理后台都偷懒没做这部分的工作。

所以这里偷懒，直接把用户拥有的所有资源返回给前端。不过这也导致了不好用无状态的jwt来代替session。
