export function actions (node, actions) {
    const objects = []

    if (actions) {
        for (let i = 0; i < actions.length; i++) {
            const isArray = Array.isArray(actions[i])
            const action = isArray ? actions[i][0] : actions[i]
            if (isArray && actions[i].length > 1) {
                objects.push(action(node, actions[i][1]))
            } else {
                objects.push(action(node))
            }
        }
    }

    return {
        destroy () {
            for (let i = 0; i < objects.length; i++) {
                if (objects[i] && 'destroy' in objects[i]) {
                    objects[i].destroy()
                }
            }
        },

        update (actions) {
            if ((actions && actions.length || 0) != objects.length) {
                throw new Error('You must not change the length of an actions array.')
            }

            if (actions) {
                for (let i = 0; i < actions.length; i++) {
                    if (objects[i] && 'update' in objects[i]) {
                        const isArray = Array.isArray(actions[i])
                        if (isArray && actions[i].length > 1) {
                            objects[i].update(actions[i][1])
                        } else {
                            objects[i].update()
                        }
                    }
                }
            }
        }
    }
}
