/*
 * @author: tisfeng
 * @createTime: 2022-08-05 10:56
 * @lastEditor: tisfeng
 * @lastEditTime: 2023-10-12 16:42
 * @fileName: consts.ts
 *
 * Copyright (c) 2022 by tisfeng, All Rights Reserved.
 */

import { LanguageItem } from "./type";

/**
 * Language item list. Currently support 47 languages.
 *
 * Todo: add more translation supported languages. such as Google support more languages.
 */
export const languageItemList: LanguageItem[] = [
  {
    googleLangCode: "auto", // "auto" means this API support auto detect language.
    youdaoLangCode: "auto",
    volcanoLangCode: "",
    bingLangCode: "auto-detect",
    // appleLangCode: "auto",
    // deepLSourceId: "auto",
    francLangCode: "und", // 'und', means undetermined
    aliyunLangCode: "auto",
    // tencentLangCode: "auto",
    baiduLangCode: "auto",
    // caiyunLangCode: "auto",
    langEnglishName: "Auto",
    langChineseName: "自动识别",
    appleDetectLangChineseName: "自动识别",
    emoji: "🌐",
  },
  {
    googleLangCode: "zh-CN",
    youdaoLangCode: "zh-CHS",
    volcanoLangCode: "zh",
    bingLangCode: "zh-Hans",
    appleLangCode: "zh_CN",
    deepLSourceId: "ZH",
    francLangCode: "cmn",
    aliyunLangCode: "zh",
    tencentDetectCode: "zh",
    tencentLangCode: "zh",
    baiduLangCode: "zh", // common lang
    caiyunLangCode: "zh",
    langEnglishName: "Chinese-Simplified",
    langChineseName: "简体中文",
    appleDetectLangChineseName: "简体中文",
    voiceList: ["Ting-Ting"], // use { say -v '?'} to get voice list.
    emoji: "🇨🇳",
  },
  {
    googleLangCode: "en",
    youdaoLangCode: "en",
    volcanoLangCode: "en",
    bingLangCode: "en",
    appleLangCode: "en_US",
    deepLSourceId: "EN",
    deepLTargetId: "EN-US", // "EN-GB" "EN-US"
    francLangCode: "eng",
    aliyunLangCode: "en",
    tencentDetectCode: "en",
    tencentLangCode: "en",
    baiduLangCode: "en", // common lang
    caiyunLangCode: "en",
    langEnglishName: "English",
    langChineseName: "英语",
    appleDetectLangChineseName: "英语",
    voiceList: ["Samantha", "Alex"], // * Note: 'Alex' is not built-in voice in macOS 13.0+, user need to download manually and cost 885M storage.
    emoji: "🇺🇸",
  },
  {
    googleLangCode: "zh-TW",
    youdaoLangCode: "zh-CHT",
    volcanoLangCode: "zh-Hant",
    bingLangCode: "zh-Hant",
    appleLangCode: "zh_TW",
    francLangCode: "cmn",
    aliyunLangCode: "zh-tw",
    tencentLangCode: "zh-TW",
    baiduLangCode: "cht", // common lang
    langEnglishName: "Chinese-Traditional",
    langChineseName: "繁体中文",
    appleDetectLangChineseName: "繁体中文",
    voiceList: ["Ting-Ting"],
    emoji: "🇭🇰",
  },
  {
    googleLangCode: "ja",
    youdaoLangCode: "ja",
    volcanoLangCode: "ja",
    bingLangCode: "ja",
    appleLangCode: "ja_JP",
    deepLSourceId: "JA",
    francLangCode: "jpn",
    aliyunLangCode: "ja",
    tencentDetectCode: "jp",
    tencentLangCode: "ja",
    baiduLangCode: "jp", // common lang
    caiyunLangCode: "ja",
    langEnglishName: "Japanese",
    langChineseName: "日语",
    appleDetectLangChineseName: "日语",
    voiceList: ["Kyoko"],
    emoji: "🇯🇵",
  },
  {
    googleLangCode: "ko",
    youdaoLangCode: "ko",
    volcanoLangCode: "ko",
    bingLangCode: "ko",
    appleLangCode: "ko_KR",
    deepLSourceId: "ko",
    francLangCode: "kor",
    aliyunLangCode: "ko",
    tencentDetectCode: "kr",
    tencentLangCode: "ko",
    baiduLangCode: "kor", // common lang
    langEnglishName: "Korean",
    langChineseName: "韩语",
    appleDetectLangChineseName: "韩语",
    voiceList: ["Yuna"],
    emoji: "🇰🇷",
  },
  {
    googleLangCode: "fr",
    youdaoLangCode: "fr",
    volcanoLangCode: "fr",
    bingLangCode: "fr",
    appleLangCode: "fr_FR",
    deepLSourceId: "FR",
    francLangCode: "fra",
    aliyunLangCode: "fr",
    tencentDetectCode: "fr",
    tencentLangCode: "fr",
    baiduLangCode: "fra", // common lang
    langEnglishName: "French",
    langChineseName: "法语",
    appleDetectLangChineseName: "法语",
    voiceList: ["Amélie", "Thomas"],
    emoji: "🇫🇷",
  },
  {
    googleLangCode: "es",
    youdaoLangCode: "es",
    volcanoLangCode: "es",
    bingLangCode: "es",
    appleLangCode: "es_ES",
    deepLSourceId: "ES",
    francLangCode: "spa",
    aliyunLangCode: "es",
    tencentDetectCode: "es",
    tencentLangCode: "es",
    baiduLangCode: "spa", // common lang
    langEnglishName: "Spanish",
    langChineseName: "西班牙语",
    appleDetectLangChineseName: "西班牙语",
    voiceList: ["Jorge", "Juan", "Diego", "Monica", "Paulina"],
    emoji: "🇪🇸",
  },
  {
    googleLangCode: "pt",
    youdaoLangCode: "pt",
    volcanoLangCode: "pt",
    bingLangCode: "pt",
    appleLangCode: "pt_BR",
    deepLSourceId: "PT",
    deepLTargetId: "PT-PT", // "PT-PT" "PT-BR"
    francLangCode: "por",
    aliyunLangCode: "pt",
    tencentDetectCode: "pt",
    tencentLangCode: "pt",
    baiduLangCode: "pt", // common lang
    langEnglishName: "Portuguese",
    langChineseName: "葡萄牙语",
    appleDetectLangChineseName: "葡萄牙语",
    voiceList: ["Joana", "Luciana"],
    emoji: "🇵🇹",
  },
  {
    googleLangCode: "it",
    youdaoLangCode: "it",
    volcanoLangCode: "it",
    bingLangCode: "it",
    appleLangCode: "it_IT",
    deepLSourceId: "IT",
    francLangCode: "ita",
    aliyunLangCode: "it",
    tencentDetectCode: "it",
    tencentLangCode: "it",
    baiduLangCode: "it", // common lang
    langEnglishName: "Italian",
    langChineseName: "意大利语",
    appleDetectLangChineseName: "意大利语",
    voiceList: ["Alice", "Luca"],
    emoji: "🇮🇹",
  },
  {
    googleLangCode: "de",
    youdaoLangCode: "de",
    volcanoLangCode: "de",
    bingLangCode: "de",
    appleLangCode: "de_DE",
    deepLSourceId: "DE",
    francLangCode: "deu",
    aliyunLangCode: "de",
    tencentDetectCode: "de",
    tencentLangCode: "de",
    baiduLangCode: "de", // common lang
    langEnglishName: "German",
    langChineseName: "德语",
    appleDetectLangChineseName: "德语",
    voiceList: ["Anna"],
    emoji: "🇩🇪",
  },
  {
    googleLangCode: "ru",
    youdaoLangCode: "ru",
    volcanoLangCode: "ru",
    bingLangCode: "ru",
    appleLangCode: "ru_RU",
    deepLSourceId: "RU",
    francLangCode: "rus",
    aliyunLangCode: "ru",
    tencentDetectCode: "ru",
    tencentLangCode: "ru",
    baiduLangCode: "ru", // common lang
    langEnglishName: "Russian",
    langChineseName: "俄语",
    appleDetectLangChineseName: "俄语",
    voiceList: ["Milena", "Yuri"],
    emoji: "🇷🇺",
  },
  {
    googleLangCode: "ar",
    youdaoLangCode: "ar",
    volcanoLangCode: "ar",
    bingLangCode: "ar",
    appleLangCode: "ar_AE",
    deepLSourceId: "AR",
    francLangCode: "arb",
    aliyunLangCode: "ar",
    tencentLangCode: "ar",
    baiduLangCode: "ara", // common lang
    langEnglishName: "Arabic",
    langChineseName: "阿拉伯语",
    appleDetectLangChineseName: "阿拉伯语",
    voiceList: ["Maged"],
    emoji: "🇦🇪",
  },
  {
    googleLangCode: "sv",
    youdaoLangCode: "sv",
    volcanoLangCode: "sv",
    bingLangCode: "sv",
    deepLSourceId: "SV",
    francLangCode: "swe",
    aliyunLangCode: "sv",
    baiduLangCode: "swe", // common lang
    langEnglishName: "Swedish",
    langChineseName: "瑞典语",
    appleDetectLangChineseName: "瑞典语",
    voiceList: ["Alva"],
    emoji: "🇸🇪",
  },
  {
    googleLangCode: "ro",
    youdaoLangCode: "ro",
    volcanoLangCode: "ro",
    bingLangCode: "ro",
    deepLSourceId: "RO",
    francLangCode: "ron",
    aliyunLangCode: "ro",
    baiduLangCode: "rom", // commone lang
    langEnglishName: "Romanian",
    langChineseName: "罗马尼亚语",
    appleDetectLangChineseName: "罗马尼亚语",
    voiceList: ["Ioana"],
    emoji: "🇷🇴",
  },
  {
    googleLangCode: "th",
    youdaoLangCode: "th",
    volcanoLangCode: "th",
    bingLangCode: "th",
    appleLangCode: "th_TH",
    francLangCode: "tha",
    aliyunLangCode: "th",
    tencentDetectCode: "th",
    tencentLangCode: "th",
    baiduLangCode: "th", // commone lang
    langEnglishName: "Thai",
    langChineseName: "泰语",
    appleDetectLangChineseName: "泰语",
    voiceList: ["Kanya"],
    emoji: "🇹🇭",
  },
  {
    googleLangCode: "sk",
    youdaoLangCode: "sk",
    volcanoLangCode: "sk",
    bingLangCode: "sk",
    deepLSourceId: "SK",
    francLangCode: "slk",
    aliyunLangCode: "sk",
    baiduLangCode: "slo", // commone lang
    langEnglishName: "Slovak",
    langChineseName: "斯洛伐克语",
    appleDetectLangChineseName: "斯洛伐克语",
    voiceList: ["Laura"],
    emoji: "🇸🇰",
  },
  {
    googleLangCode: "nl",
    youdaoLangCode: "nl",
    volcanoLangCode: "nl",
    bingLangCode: "nl",
    appleLangCode: "nl_NL",
    deepLSourceId: "NL",
    francLangCode: "nld",
    aliyunLangCode: "nl",
    baiduLangCode: "nl", // commone lang
    langEnglishName: "Dutch",
    voiceList: ["Ellen", "Xander"],
    langChineseName: "荷兰语",
    appleDetectLangChineseName: "荷兰语",
    emoji: "🇳🇱",
  },
  {
    googleLangCode: "hu",
    youdaoLangCode: "hu",
    volcanoLangCode: "hu",
    bingLangCode: "hu",
    deepLSourceId: "HU",
    francLangCode: "hun",
    aliyunLangCode: "hu",
    baiduLangCode: "hu", // commone lang
    langEnglishName: "Hungarian",
    langChineseName: "匈牙利语",
    appleDetectLangChineseName: "匈牙利语",
    voiceList: ["Mariska"],
    emoji: "🇭🇺",
  },
  {
    googleLangCode: "el",
    youdaoLangCode: "el",
    volcanoLangCode: "el",
    bingLangCode: "el",
    deepLSourceId: "EL",
    francLangCode: "ell",
    aliyunLangCode: "el",
    baiduLangCode: "el", // commone lang
    langEnglishName: "Greek",
    langChineseName: "希腊语",
    appleDetectLangChineseName: "希腊语",
    voiceList: ["Melina"],
    emoji: "🇬🇷",
  },
  {
    googleLangCode: "da",
    youdaoLangCode: "da",
    volcanoLangCode: "da",
    bingLangCode: "da",
    deepLSourceId: "DA",
    francLangCode: "dan",
    aliyunLangCode: "da",
    baiduLangCode: "dan", // commone lang
    langEnglishName: "Danish",
    langChineseName: "丹麦语",
    appleDetectLangChineseName: "丹麦语",
    voiceList: ["Sara"],
    emoji: "🇩🇰",
  },
  {
    googleLangCode: "fi",
    youdaoLangCode: "fi",
    volcanoLangCode: "fi",
    bingLangCode: "fi",
    deepLSourceId: "FI",
    francLangCode: "fin",
    aliyunLangCode: "fi",
    baiduLangCode: "fin", // commone lang
    langEnglishName: "Finnish",
    langChineseName: "芬兰语",
    appleDetectLangChineseName: "芬兰语",
    voiceList: ["Satu"],
    emoji: "🇫🇮",
  },
  {
    googleLangCode: "pl",
    youdaoLangCode: "pl",
    volcanoLangCode: "pl",
    bingLangCode: "pl",
    appleLangCode: "pl_PL",
    deepLSourceId: "PL",
    francLangCode: "pol",
    aliyunLangCode: "pl",
    baiduLangCode: "pl", // commone lang
    langEnglishName: "Polish",
    langChineseName: "波兰语",
    appleDetectLangChineseName: "波兰语",
    voiceList: ["Zosia"],
    emoji: "🇵🇱",
  },
  {
    googleLangCode: "cs",
    youdaoLangCode: "cs",
    volcanoLangCode: "cs",
    bingLangCode: "cs",
    deepLSourceId: "CS",
    francLangCode: "ces",
    aliyunLangCode: "cs",
    baiduLangCode: "cs", // commone lang
    langEnglishName: "Czech",
    langChineseName: "捷克语",
    appleDetectLangChineseName: "捷克语",
    voiceList: ["Zuzana"],
    emoji: "🇨🇿",
  },
  {
    googleLangCode: "tr",
    youdaoLangCode: "tr",
    volcanoLangCode: "tr",
    bingLangCode: "tr",
    appleLangCode: "tr_TR",
    deepLSourceId: "TR",
    francLangCode: "tur",
    aliyunLangCode: "tr",
    tencentLangCode: "tr",
    tencentDetectCode: "tr",
    baiduLangCode: "tr",
    langEnglishName: "Turkish",
    langChineseName: "土耳其语",
    appleDetectLangChineseName: "土耳其语",
    voiceList: ["Filiz"],
    emoji: "🇹🇷",
  },
  {
    googleLangCode: "lt",
    youdaoLangCode: "lt",
    volcanoLangCode: "lt",
    bingLangCode: "lt",
    deepLSourceId: "LT",
    francLangCode: "lit",
    aliyunLangCode: "lt",
    baiduLangCode: "lit",
    langEnglishName: "Lithuanian",
    langChineseName: "立陶宛语",
    appleDetectLangChineseName: "立陶宛语",
    voiceList: ["Milda"],
    emoji: "🇱🇹",
  },
  {
    googleLangCode: "lv",
    youdaoLangCode: "lv",
    volcanoLangCode: "lv",
    bingLangCode: "lv",
    deepLSourceId: "LV",
    francLangCode: "lav",
    aliyunLangCode: "lv",
    baiduLangCode: "lav",
    langEnglishName: "Latvian",
    langChineseName: "拉脱维亚语",
    appleDetectLangChineseName: "拉脱维亚语",
    voiceList: ["Liga"],
    emoji: "🇱🇻",
  },
  {
    googleLangCode: "uk",
    youdaoLangCode: "uk",
    volcanoLangCode: "uk",
    bingLangCode: "uk",
    appleLangCode: "uk_UA",
    deepLSourceId: "UK",
    francLangCode: "ukr",
    aliyunLangCode: "uk",
    baiduLangCode: "ukr",
    langEnglishName: "Ukrainian",
    langChineseName: "乌克兰语",
    appleDetectLangChineseName: "乌克兰语",
    voiceList: ["Oksana"],
    emoji: "🇺🇦",
  },
  {
    googleLangCode: "bg",
    youdaoLangCode: "bg",
    volcanoLangCode: "bg",
    bingLangCode: "bg",
    deepLSourceId: "BG",
    francLangCode: "bul",
    aliyunLangCode: "bg",
    baiduLangCode: "bul", // common lang
    langEnglishName: "Bulgarian",
    langChineseName: "保加利亚语",
    appleDetectLangChineseName: "保加利亚语",
    voiceList: ["Tanya"],
    emoji: "🇧🇬",
  },
  {
    googleLangCode: "id",
    youdaoLangCode: "id",
    volcanoLangCode: "id",
    bingLangCode: "id",
    appleLangCode: "id_ID",
    deepLSourceId: "ID",
    francLangCode: "ind",
    aliyunLangCode: "id",
    tencentLangCode: "id",
    tencentDetectCode: "id",
    baiduLangCode: "id",
    langEnglishName: "Indonesian",
    langChineseName: "印尼语",
    appleDetectLangChineseName: "印尼语",
    voiceList: ["Ardi"],
    emoji: "🇮🇩",
  },
  {
    googleLangCode: "ms",
    youdaoLangCode: "ms",
    volcanoLangCode: "ms",
    bingLangCode: "ms",
    francLangCode: "msa",
    aliyunLangCode: "ms",
    tencentDetectCode: "ms",
    tencentLangCode: "ms",
    baiduLangCode: "msa",
    langEnglishName: "Malay",
    langChineseName: "马来语",
    appleDetectLangChineseName: "马来语",
    voiceList: ["Rizwan"],
    emoji: "🇲🇾",
  },

  {
    googleLangCode: "sl",
    youdaoLangCode: "sl",
    volcanoLangCode: "sl",
    bingLangCode: "sl",
    deepLSourceId: "SL",
    francLangCode: "slv",
    aliyunLangCode: "sl",
    baiduLangCode: "slv", // common lang
    langEnglishName: "Slovenian",
    langChineseName: "斯洛文尼亚语",
    appleDetectLangChineseName: "斯洛文尼亚语",
    voiceList: ["Lado"],
    emoji: "🇸🇮",
  },
  {
    googleLangCode: "et",
    youdaoLangCode: "et",
    volcanoLangCode: "et",
    bingLangCode: "et",
    deepLSourceId: "ET",
    francLangCode: "est",
    aliyunLangCode: "et",
    baiduLangCode: "est", // common lang
    langEnglishName: "Estonian",
    langChineseName: "爱沙尼亚语",
    appleDetectLangChineseName: "爱沙尼亚语",
    voiceList: ["Kertu"],
    emoji: "🇪🇪",
  },
  {
    googleLangCode: "vi",
    youdaoLangCode: "vi",
    volcanoLangCode: "vi",
    bingLangCode: "vi",
    appleLangCode: "vi_VN",
    francLangCode: "vie",
    aliyunLangCode: "vi",
    tencentDetectCode: "vi",
    tencentLangCode: "vi",
    baiduLangCode: "vie", // common lang
    langEnglishName: "Vietnamese",
    langChineseName: "越南语",
    appleDetectLangChineseName: "越南语",
    voiceList: ["Minh"],
    emoji: "🇻🇳",
  },
  {
    googleLangCode: "fa",
    youdaoLangCode: "fa",
    volcanoLangCode: "fa",
    bingLangCode: "fa",
    francLangCode: "fas",
    aliyunLangCode: "fa",
    baiduLangCode: "per",
    langEnglishName: "Persian",
    langChineseName: "波斯语",
    appleDetectLangChineseName: "波斯语",
    voiceList: ["Zahra"],
    emoji: "🇮🇷",
  },
  {
    googleLangCode: "hi",
    youdaoLangCode: "hi",
    volcanoLangCode: "hi",
    bingLangCode: "hi",
    francLangCode: "hin",
    aliyunLangCode: "hi",
    tencentLangCode: "hi",
    baiduLangCode: "hin",
    langEnglishName: "Hindi",
    langChineseName: "印地语",
    appleDetectLangChineseName: "印地语",
    voiceList: ["Aditi"],
    emoji: "🇮🇳",
  },
  {
    googleLangCode: "te",
    youdaoLangCode: "te",
    volcanoLangCode: "te",
    bingLangCode: "te",
    francLangCode: "tel",
    aliyunLangCode: "te",
    baiduLangCode: "tel",
    langEnglishName: "Telugu",
    langChineseName: "泰卢固语",
    appleDetectLangChineseName: "泰卢固语",
    voiceList: ["Chitra"],
    emoji: "🇮🇳",
  },
  {
    googleLangCode: "ta",
    youdaoLangCode: "ta",
    volcanoLangCode: "ta",
    bingLangCode: "ta",
    francLangCode: "tam",
    aliyunLangCode: "ta",
    baiduLangCode: "tam",
    langEnglishName: "Tamil",
    langChineseName: "泰米尔语",
    appleDetectLangChineseName: "泰米尔语",
    voiceList: ["Chitra"],
    emoji: "🇮🇳",
  },
  {
    googleLangCode: "ur",
    youdaoLangCode: "ur",
    volcanoLangCode: "ur",
    bingLangCode: "ur",
    francLangCode: "urd",
    aliyunLangCode: "ur",
    baiduLangCode: "urd",
    langEnglishName: "Urdu",
    langChineseName: "乌尔都语",
    appleDetectLangChineseName: "乌尔都语",
    voiceList: ["Aditi"],
    emoji: "🇵🇰",
  },
  {
    googleLangCode: "tl",
    youdaoLangCode: "tl",
    volcanoLangCode: "tl",
    bingLangCode: "fil",
    francLangCode: "tgl",
    aliyunLangCode: "tl",
    baiduLangCode: "fil",
    langEnglishName: "Tagalog",
    langChineseName: "菲律宾语",
    appleDetectLangChineseName: "菲律宾语",
    voiceList: ["Aditi"],
    emoji: "🇵🇭",
  },
  {
    googleLangCode: "km",
    youdaoLangCode: "km",
    volcanoLangCode: "km",
    bingLangCode: "km",
    francLangCode: "khm",
    aliyunLangCode: "km",
    baiduLangCode: "khm",
    langEnglishName: "Khmer",
    langChineseName: "高棉语",
    appleDetectLangChineseName: "高棉语",
    voiceList: ["Aditi"],
    emoji: "🇰🇭",
  },
  {
    googleLangCode: "lo",
    youdaoLangCode: "lo",
    volcanoLangCode: "lo",
    bingLangCode: "lo",
    francLangCode: "lao",
    aliyunLangCode: "lo",
    baiduLangCode: "lo",
    langEnglishName: "Lao",
    langChineseName: "老挝语",
    appleDetectLangChineseName: "老挝语",
    voiceList: ["Aditi"],
    emoji: "🇱🇦",
  },
  {
    googleLangCode: "bn",
    youdaoLangCode: "bn",
    volcanoLangCode: "bn",
    bingLangCode: "bn",
    francLangCode: "ben",
    aliyunLangCode: "bn",
    baiduLangCode: "ben",
    langEnglishName: "Bengali",
    langChineseName: "孟加拉语",
    appleDetectLangChineseName: "孟加拉语",
    voiceList: ["Nusrat"],
    emoji: "🇧🇩",
  },
  {
    googleLangCode: "my",
    youdaoLangCode: "my",
    volcanoLangCode: "my",
    bingLangCode: "my",
    francLangCode: "mya",
    aliyunLangCode: "my",
    baiduLangCode: "bur",
    langEnglishName: "Burmese",
    langChineseName: "缅甸语",
    appleDetectLangChineseName: "缅甸语",
    voiceList: ["Aditi"],
    emoji: "🇲🇲",
  },
  {
    googleLangCode: "no",
    youdaoLangCode: "no",
    volcanoLangCode: "no",
    bingLangCode: "nb",
    francLangCode: "nor",
    aliyunLangCode: "no",
    baiduLangCode: "nor",
    deepLSourceId: "nb",
    langEnglishName: "Norwegian",
    langChineseName: "挪威语",
    appleDetectLangChineseName: "书面挪威语",
    voiceList: ["Liv"],
    emoji: "🇳🇴",
  },
  {
    googleLangCode: "sr",
    youdaoLangCode: "sr-Latn",
    volcanoLangCode: "sr",
    bingLangCode: "sr-Latn",
    francLangCode: "srp",
    baiduLangCode: "srp",
    langEnglishName: "Serbian",
    langChineseName: "塞尔维亚语",
    appleDetectLangChineseName: "塞尔维亚语",
    voiceList: ["Liv"],
    emoji: "🇷🇸",
  },
  {
    googleLangCode: "hr",
    youdaoLangCode: "hr",
    volcanoLangCode: "hr",
    bingLangCode: "hr",
    francLangCode: "hrv",
    aliyunLangCode: "hbs",
    baiduLangCode: "hrv",
    langEnglishName: "Croatian",
    langChineseName: "克罗地亚语",
    appleDetectLangChineseName: "克罗地亚语",
    voiceList: ["Liv"],
    emoji: "🇭🇷",
  },
  {
    googleLangCode: "mn",
    youdaoLangCode: "mn",
    volcanoLangCode: "mn",
    bingLangCode: "mn-Cyrl",
    francLangCode: "mon",
    aliyunLangCode: "mn",
    baiduLangCode: "mon",
    langEnglishName: "Mongolian",
    langChineseName: "蒙古语",
    appleDetectLangChineseName: "蒙古语",
    voiceList: ["Liv"],
    emoji: "🇲🇳",
  },
  {
    googleLangCode: "iw",
    youdaoLangCode: "he",
    volcanoLangCode: "he",
    bingLangCode: "he",
    francLangCode: "heb",
    aliyunLangCode: "he",
    baiduLangCode: "heb",
    langEnglishName: "Hebrew",
    langChineseName: "希伯来语",
    appleDetectLangChineseName: "希伯来语",
    voiceList: ["Liv"],
    emoji: "🇮🇱",
  },
];

/**
 * Auto detect language item.
 */
export const autoDetectLanguageItem = languageItemList[0];
/**
 * Chinese-Simplified language item.
 */
export const chineseLanguageItem = languageItemList[1];
/**
 * English language item.
 */
export const englishLanguageItem = languageItemList[2];
