# SpringBoot 
Building Enterprise Java Applications the Spring Way
## Example
- Preventing brute force authentication attempts
- Block user account after 3 consecutive failed login attempts
- Limit maximum sessions for user
- Setting session timeout and update database table on timeout
- Roles & Permissions management
- Tracking user logon
- Forgot password and send email reset password
- Forcing user to change a password at the first time login
- Forcing user to change expired password
- Paging, Searching and Sorting data
- Pagination result using select2 ajax remote data
- Sending email template with attachment
- Multiple languages web application
- Generate PDF and Excel file 
- Uploading both data and files in one form using Ajax

## Building and running

	mvn package
	java -jar SpringBoot-0.0.1-SNAPSHOT.war 
	
![Capture](https://user-images.githubusercontent.com/15135199/56458276-cb6eb400-63ae-11e9-8156-c3ba4ebac3c7.PNG)


![999](https://user-images.githubusercontent.com/15135199/56112785-45093b00-5f86-11e9-9547-f1d5147c4e7f.PNG)


![222](https://user-images.githubusercontent.com/15135199/55684488-4a0e2f00-5975-11e9-9968-2a0399ebe027.PNG)


![333](https://user-images.githubusercontent.com/15135199/55687043-a764a900-5992-11e9-9deb-178e8164df76.PNG)


![444](https://user-images.githubusercontent.com/15135199/55782710-177c4780-5ad7-11e9-87a1-0e2b5e820472.PNG)


![Capture](https://user-images.githubusercontent.com/15135199/55896742-2f43f080-5be9-11e9-8108-4967ae457e66.PNG)

## Uploading both data and files in one form using Ajax
- Excel Sample Data

![ccc](https://user-images.githubusercontent.com/15135199/56190157-d4c8eb00-6053-11e9-9ea3-44519fed2a57.PNG)
- Form upload and read Excel file

![Capture](https://user-images.githubusercontent.com/15135199/56460107-8905a100-63c7-11e9-83a6-39e0151a88ed.PNG)

- Convert Excel data to table and validate data pre save

![sss](https://user-images.githubusercontent.com/15135199/56460122-edc0fb80-63c7-11e9-9d9f-146bd258849b.PNG)

![valid](https://user-images.githubusercontent.com/15135199/56232153-49c70f80-60aa-11e9-87ab-69e7a1bc50b5.PNG)


## Chart

![Capture](https://user-images.githubusercontent.com/15135199/57978243-7ec0dc00-7a33-11e9-8aad-1bf0c540d7ec.PNG)

## Forgot password send Email reset password
![111](https://user-images.githubusercontent.com/15135199/56121506-768c0180-5f9a-11e9-9ecc-8f8d0c5f7605.PNG)
![555](https://user-images.githubusercontent.com/15135199/56121055-8d7e2400-5f99-11e9-9971-76b2f869c8e8.PNG)
![eee](https://user-images.githubusercontent.com/15135199/56230144-e33ff280-60a5-11e9-8670-9fd5b10c415d.PNG)

## Tracking user logon with Socket
![Record_2019_08_18_22_23_56_713](https://user-images.githubusercontent.com/15135199/63226785-c577cb00-c208-11e9-8eca-2bde013d5850.gif)

## Ref
- https://www.baeldung.com/httpclient-ssl
- https://www.devglan.com/spring-boot/spring-boot-websocket-integration-example
- https://www.java67.com/2016/10/5-difference-between-stringbuffer.html
- https://www.journaldev.com/741/java-socket-programming-server-client
- https://github.com/up1/soa_group6/wiki/Cross-Origin-Resource-Sharing-(CORS)
- https://medium.com/@phayao/ทำให้-token-ซับซ้อนด้วย-jwt-ใน-spring-boot-a74293bbc736
- https://medium.com/@dassum/securing-spring-boot-rest-api-with-json-web-token-and-jdbc-token-store-67558a7d6c29
- https://javadeveloperzone.com/spring-boot/spring-boot-oauth2-jdbc-token-store-example/
- https://www.baeldung.com/spring-security-create-new-custom-security-expression
- https://medium.com/better-programming/secure-a-spring-boot-rest-api-with-json-web-token-reference-to-angular-integration-e57a25806c50
- https://pattern-match.com/blog/2018/10/17/springboot2-with-oauth2-integration/
- https://www.youtube.com/watch?time_continue=422&v=wxebTn_a930
- http://www.thinkplexx.com/learn/howto/security/tools/understanding-java-keytool-working-with-crt-files-fixing-certificate-problems
- https://stackoverflow.com/questions/4325263/how-to-import-a-cer-certificate-into-a-java-keystore
- https://docs.spring.io/spring-boot/docs/current/reference/html/appendix-application-properties.html
- https://www.vogella.com/tutorials/JavaPerformance/article.html
- https://www.javainuse.com/spring/springboot_session_redis
- https://docs.spring.io/spring-session/docs/current/reference/html5/guides/boot-redis.html
- https://www.callicoder.com/configuring-spring-boot-application/
- https://github.com/spring-projects/spring-security-oauth/blob/master/spring-security-oauth2/src/test/resources/schema.sql
- https://www.devglan.com/spring-security/spring-boot-security-oauth2-example
- https://sysadmin.psu.ac.th/2019/03/03/what-is-oauth2/
