<br /><br /><br />

<div align="center">
<img width="500px" src="https://tinyhttp.v1rtl.site/logo.svg" alt="tinyhttp" />
<p><sub>⚡ Tiny web framework as a replacement of Express</sub></p><br />

[![][site-badge]][site-url] [![npm][npm-img]][npm-url]
[![GitHub Workflow
Status][gh-actions-img]][github-actions]
[![Coverage][cov-img]][cov-url] [![][code-quality-img]][code-quality]

</div>
<br /><br />

_**tinyhttp**_ is a modern [Express](https://expressjs.com/)-like web framework
written in TypeScript and compiled to native ESM, that uses a bare minimum
amount of dependencies trying to avoid legacy hell.

## Features

- ⚡
  [58% faster](https://web-frameworks-benchmark.netlify.app/result?f=tinyhttp,express)
  than Express
- ⚙ Express middleware compat
- ↪ Async middleware support
- ☑ ESM-only
- 🚀 No legacy dependencies, just the JavaScript itself
- 🔨 Types out of the box
- 🔥 Prebuilt middleware for modern Node.js

Visit [tinyhttp website](https://tinyhttp.v1rtl.site) for docs, guides and
middleware search.

## Install

[Node.js 14.21.3+](https://node.green/#ES2022) is required.

```sh
pnpm i @tinyhttp/app
```

## Donate

You can donate with fiat or crypto
[here](https://github.com/tinyhttp/tinyhttp?sponsor=1).

## Sponsors

<table>
  <tr>
    <td align="center"><a href="http://deta.sh?ref=tinyhttp"><img src="https://i.snipboard.io/VFbSna.jpg" width="100px;" alt=""/><br /><sub><b>Deta</b></sub></td> <td align="center"><a href="https://molefrog.com/"><img src="https://avatars3.githubusercontent.com/u/671276?v=4" width="100px;" alt=""/><br /><sub><b>molefrog</b></sub></td>
  </tr>

</table>

## Contributing

There are many ways to contribute:

- [Submit bugs or feature requests](https://github.com/tinyhttp/tinyhttp/issues)
- Adding a new feature or addressing bugs yourself
- Review [documentation](https://tinyhttp.v1rtl.site/) and fix typos or add new
  content

For ways to contribute, please see the
[documentation](https://github.com/tinyhttp/tinyhttp/blob/master/CONTRIBUTING.md).

[site-url]: https://tinyhttp.v1rtl.site
[npm-url]: https://npmjs.com/package/@tinyhttp/app
[github-actions]: https://github.com/tinyhttp/tinyhttp/actions
[gh-actions-img]: https://img.shields.io/github/actions/workflow/status/tinyhttp/tinyhttp/main.yml?branch=master&style=for-the-badge&logo=github&label=&color=hotpink
[cov-img]: https://img.shields.io/coveralls/github/tinyhttp/tinyhttp?style=for-the-badge&color=hotpink
[cov-url]: https://coveralls.io/github/tinyhttp/tinyhttp
[code-quality-img]: https://img.shields.io/codefactor/grade/github/tinyhttp/tinyhttp?style=for-the-badge&color=hotpink
[code-quality]: https://www.codefactor.io/repository/github/tinyhttp/tinyhttp
[npm-img]: https://img.shields.io/npm/dt/@tinyhttp/app?style=for-the-badge&color=hotpink&logo=npm&label=
[site-badge]: https://img.shields.io/badge/website-open-hotpink?style=for-the-badge
