﻿// 32feet.NET - Personal Area Networking for .NET
//
// Net.Bluetooth.StonestreetOne.BluetopiaError
// 
// Copyright (c) 2010 Alan J.McFarlane, All rights reserved.
// Copyright (c) 2010 In The Hand Ltd, All rights reserved.
// This source code is licensed under the In The Hand Community License - see License.txt

using System;

namespace InTheHand.Net.Bluetooth.StonestreetOne
{
    internal enum BluetopiaError // "BTPS_ERROR_..." and "SYMB_ERROR_..."
    {
        OK = 0,

        #region BtErrors.h
        INVALID_PARAMETER = (-1),
        INVALID_BLUETOOTH_STACK_ID = (-2),
        DLL_INITIALIZATION_ERROR = (-3),
        HCI_INITIALIZATION_ERROR = (-4),
        GAP_INITIALIZATION_ERROR = (-5),
        SCO_INITIALIZATION_ERROR = (-6),
        L2CAP_INITIALIZATION_ERROR = (-7),
        RFCOMM_INITIALIZATION_ERROR = (-8),
        SDP_INITIALIZATION_ERROR = (-9),
        SPP_INITIALIZATION_ERROR = (-10),
        GOEP_INITIALIZATION_ERROR = (-11),
        OTP_INITIALIZATION_ERROR = (-12),
        DEBUG_CALLBACK_ALREADY_INSTALLED = (-13),
        HCI_DRIVER_ERROR = (-14),
        DEVICE_RESET_ERROR = (-15),
        HCI_RESPONSE_ERROR = (-16),
        HCI_TIMEOUT_ERROR = (-17),
        UNSUPPORTED_HCI_VERSION = (-18),
        UNKNOWN_SUPPORTED_FEATURES = (-19),
        UNKNOWN_HCI_BUFFER_SIZE = (-20),
        UNABLE_TO_REGISTER_EVENT_CALLBACK = (-21),
        UNABLE_TO_REGISTER_ACL_CALLBACK = (-22),
        UNABLE_TO_REGISTER_SCO_CALLBACK = (-23),
        SIGNALLING_MTU_EXCEEDED = (-24),
        UNABLE_TO_REGISTER_PSM = (-25),
        L2CAP_NOT_INITIALIZED = (-26),
        UNABLE_TO_UNREGISTER_PSM = (-27),
        PSM_NOT_REGISTERED = (-28),
        ATTEMPTING_CONNECTION_TO_DEVICE = (-29),
        ACCEPTING_CONNECTION_FROM_DEVICE = (-30),
        INVALID_FLUSH_TIMEOUT_VALUE = (-31),
        INVALID_STATE_FOR_CONFIG = (-32),
        ADDING_CID_INFORMATION = (-33),
        ADDING_CONNECTION_INFORMATION = (-34),
        ADDING_IDENTIFIER_INFORMATION = (-35),
        INVALID_CONNECTION_STATE = (-36),
        CHANNEL_NOT_IN_OPEN_STATE = (-37),
        INVALID_CID = (-38),
        WRITING_DATA_TO_DEVICE = (-39),
        MEMORY_ALLOCATION_ERROR = (-40),
        NEGOTIATED_MTU_EXCEEDED = (-41),
        CONECTIONLESS_MTU_EXCEEDED = (-42),
        CID_NOT_GROUP_CID = (-43),
        GROUP_MEMBER_ALREADY_EXISTS = (-44),
        GROUP_MEMBER_NOT_FOUND = (-45),
        CONNECTION_TO_DEVICE_LOST = (-46),
        INVALID_CID_TYPE = (-47),
        SDP_DATA_ELEMENT_EXPECTED = (-48),
        SDP_INVALID_DATA_ELEMENT_LENGTH = (-49),
        SDP_NOT_INITIALIZED = (-50),
        SDP_INVALID_DATA_ELEMENT = (-51),
        ADDING_SERVICE_ATTRIBUTE = (-52),
        DELETING_SERVICE_RECORD = (-53),
        EXPECTED_UUID_ENTRY = (-54),
        SDP_INVALID_DATA_TYPE = (-55),
        GAP_NOT_INITIALIZED = (-56),
        DEVICE_HCI_ERROR = (-57),
        INVALID_MODE = (-58),
        ADDING_CALLBACK_INFORMATION = (-59),
        DELETING_CALLBACK_INFORMATION = (-60),
        NO_CALLBACK_REGISTERED = (-61),
        SCO_NOT_INITIALIZED = (-62),
        MAX_SCO_CONNECTIONS = (-63),
        INTERNAL_ERROR = (-64),
        INSUFFICIENT_BUFFER_SPACE = (-65),
        INSUFFICIENT_RESOURCES = (-66),
        RFCOMM_NOT_INITIALIZED = (-67),
        RFCOMM_ADDING_SERVER_INFORMATION = (-68),
        RFCOMM_REMOVING_SERVER_INFORMATION = (-69),
        RFCOMM_UNABLE_TO_ADD_CONNECTION_INFORMATION = (-70),
        RFCOMM_UNABLE_TO_ADD_CHANNEL_INFORMATION = (-71),
        RFCOMM_UNABLE_TO_CONNECT_TO_REMOTE_DEVICE = (-72),
        RFCOMM_UNABLE_TO_COMMUNICATE_WITH_REMOTE_DEVICE = (-73),
        RFCOMM_INVALID_TEI = (-74),
        RFCOMM_INVALID_DLCI = (-75),
        RFCOMM_DISC_ALREADY_PENDING = (-76),
        RFCOMM_TEI_IS_DISCONNECTING = (-77),
        RFCOMM_CONTROL_MESSAGE_CURRENTLY_PENDING = (-78),
        RFCOMM_FLOW_IS_DISABLED = (-79),
        RFCOMM_INVALID_MAX_FRAME_SIZE = (-80),
        RFCOMM_COMMAND_NOT_ALLOWED = (-81),
        RFCOMM_ADDING_MESSAGE_INFORMATION = (-82),
        RFCOMM_INVALID_FLOW_STATE = (-83),
        RFCOMM_MAX_FRAME_SIZE_EXCEEDED = (-84),
        SPP_NOT_INITIALIZED = (-85),
        SPP_PORT_NOT_OPENED = (-86),
        SPP_BUFFER_FULL = (-87),
        OUTSTANDING_TRANSACTION = (-88),
        TIMER_VALUE_OUT_OF_RANGE = (-89),
        GOEP_NOT_INITIALIZED = (-90),
        GOEP_COMMAND_NOT_ALLOWED = (-91),
        OTP_NOT_INITIALIZED = (-92),
        OTP_REQUEST_OUTSTANDING = (-93),
        OTP_ERROR_PARSING_DATA = (-94),
        OTP_ALREADY_CONNECTED = (-95),
        OTP_NO_CONNECTION = (-96),
        OTP_ACTION_NOT_ALLOWED = (-97),
        DEVICE_NOT_CONNECTED = (-98),
        ACTION_NOT_ALLOWED = (-99),
        SPP_BUFFER_EMPTY = (-100),
        UNSUPPORTED_PLATFORM_ERROR = (-101),
        #endregion

        #region New in the version of the SDK from M3
        UNABLE_TO_ENABLE_HC_TO_H_FLOW_CONTROL = (-102),
        //
        EPERM = (-200),
        ENOENT = (-201),
        ESRCH = (-202),
        EINTR = (-203),
        EIO = (-204),
        ENXIO = (-205),
        E2BIG = (-206),
        ENOEXEC = (-207),
        EBADF = (-208),
        ECHILD = (-209),
        EAGAIN = (-210),
        ENOMEM = (-211),
        EACCES = (-212),
        EFAULT = (-213),
        EBUSY = (-214),
        EEXIST = (-215),
        EXDEV = (-216),
        ENODEV = (-217),
        ENOTDIR = (-218),
        EISDIR = (-219),
        ENFILE = (-220),
        EMFILE = (-221),
        ENOTTY = (-222),
        EFBIG = (-223),
        ENOSPC = (-224),
        ESPIPE = (-225),
        EROFS = (-226),
        EMLINK = (-227),
        EPIPE = (-228),
        EDOM = (-229),
        EDEADLK = (-230),
        ENAMETOOLONG = (-231),
        ENOLCK = (-232),
        ENOSYS = (-233),
        ENOTEMPTY = (-234),
        EINVAL = (-235),
        ERANGE = (-236),
        EILSEQ = (-237),
        STRUNCATE = (-238),
        POINTER = (-239),
        NOT_OPEN = (-240),
        WRONG_MODE = (-241),
        BYTE_COUNT = (-242),
        INCOMPLETE_IO = (-243),
        NOT_SPECIFIED = (-244),
        EOF = (-245),
        NOT_IMPLEMENTED = (-246),
        NO_MORE_FILES = (-247),
        CRC = (-248),
        #endregion

        #region SYMBUAPI.h
        /* Error Return Codes.                                               */
        /* Error Codes that are smaller than these (less than -1000) are     */
        /* related to the Bluetooth Protocol Stack itself (see BTERRORS.H).  */
        SYMB_ERROR_INVALID_PARAMETER = (-1000),
        SYMB_ERROR_UNKNOWN_ERROR = (-1001),
        SYMB_ERROR_AUDIO_UNAVAILABLE = (-1002),
        SYMB_ERROR_UNKNOWN_AUDIO_ROLE = (-1003),
        SYMB_ERROR_NO_POWER_MANAGER = (-1004),
        #endregion
    }
}