## How to contribute

### Getting help and asking for new features

If you have any questions about tilepieces, go to 
[Q&A](https://github.com/tilepieces/tilepieces/discussions/categories/q-a).
If you want to ask about new features, please create a post on 
[new features](https://github.com/tilepieces/tilepieces/discussions/categories/new-features)

### Submitting bug reports

The preferred way to report bugs is to use the
[GitHub issue tracker](https://github.com/tilepieces/tilepieces/issues).
Use the "bug report" template and try to fill in every field. Try to add some GIFs if you think it will be useful to understand your problem.
Please be always polite.

### Contributing code

If you want to contribute to the code, don't create pull requests without saying anything first. If you want to fix a bug, ask in the dedicated issue to be assigned. If you want to implement a new feature, propose on the appropriate discussion. 
If you prefer, please contact the maintainer directly at [mantainer@tilepieces.com](mailto:mantainer@tilepieces.com)

- Make sure you have a [GitHub Account](https://github.com/signup/free)
- Fork [Tilepieces](https://github.com/tilepieces/tilepieces)
  ([how to fork a repo](https://help.github.com/articles/fork-a-repo))
- Make your changes
- Submit a pull request
  ([how to create a pull request](https://help.github.com/articles/fork-a-repo)).
  Don't put more than one feature/fix in a single pull request.

By contributing code to Tilepieces you

- agree to license the contributed code under Tilepieces's [MIT license](https://github.com/tilepieces/tilepieces/blob/main/LICENSE).

- confirm that you have the right to contribute and license the code
  in question. (Either you hold all rights on the code, or the rights
  holder has explicitly granted the right to use it like this,
  through a compatible open source license or through a direct
  agreement with you.)

### Coding standards

- 2 spaces per indentation level, no tabs.
