# Testing with Jest

Code along template: [https://github.com/thoughtworks-jumpstart/jest-starter-template](https://github.com/thoughtworks-jumpstart/jest-starter-template)

## Testing libraries

Here are the commonly used JavaScript test runner libraries: `jest`, `jasmine`, `mocha`. They are very similar in their functionality and API design, so if you master one, chances are - learning the others won't be difficult.

In this chapter, we will learn `jest` because:

* `jest` has feature-parity with other test runners \(e.g. `mocha`, `jasmine`\)
* `jest` is fast
* minimal configuration is required
* the snapshot testing feature \(which we will use later when we learn React\)

## Resources

* [An overview of javascript testing in 2018](https://medium.com/welldone-software/an-overview-of-javascript-testing-in-2018-f68950900bc3)

### Reference

* [Jest cheat sheet](https://github.com/sapegin/jest-cheat-sheet)
* [Jest Expect API Reference](https://facebook.github.io/jest/docs/en/expect.html)

## Assignment

[https://github.com/davified/tdd-with-jest](https://github.com/davified/tdd-with-jest)

