# Build a website with React

## Requirements

* Build a front-end application with React

## Skills to practice

We recommend you to practice the following skills on this project:

* Project Workflow
  * [x] Use of user stories to break your big ideas into smaller features
  * [x] UI prototyping on a piece of paper with wire-frame
  * [x] Track your task progress with tools like [Trello](https://trello.com/)
* Technical Requirements
  * Application of tools, techniques and practices learned in the current module
  * Application of clean code practices covered in class
    * [x] Good formatting/indentation
    * [x] No syntax errors / warnings
    * [x] Clear and descriptive variable names
    * [x] Consistent formatting \(e.g. semi-colons, double quotes, etc\)
    * [x] Followed naming convention for variables
    * [x] Followed naming convention for files
    * [x] No unnecessary comments
    * [x] No duplication in code \(i.e. code is DRY\)
    * [x] Functions and classes are small and adhere to Single Responsibility Principle
  * Short and descriptive README
    * [x] What your project is about
    * [x] Link to a working app on heroku
    * [x] \[Optional\] Screenshots of your app
    * [x] How to clone and run app locally
    * [x] References:
      * [markdown cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet)
      * [what a good README looks like](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2)
  * Write unit tests for your React components
    * [x] all tests pass
    * [x] clear and correct test descriptions
* Deployment
  * [x] Deployment of application to cloud provider of choice \(e.g. GitHub Pages, Heroku\)

## Useful JavaScript Utilities

* [date-fns](https://date-fns.org/)
* [momentjs](https://momentjs.com/)
* [lodash](https://lodash.com/)

## Useful React Components

* [react-big-calendar](https://github.com/intljusticemission/react-big-calendar)
* [awesome react components](https://github.com/brillout/awesome-react-components)
* [react-beautiful-dnd](https://github.com/atlassian/react-beautiful-dnd)
* [react-select](https://react-select.com/home)
* [react-map-gl](https://github.com/uber/react-map-gl)

## Project Ideas List/ Inspiration

* [Every time you build a to-do list app, a puppy dies](https://medium.freecodecamp.org/every-time-you-build-a-to-do-list-app-a-puppy-dies-505b54637a5d)
* [A list of fun apps to build](https://medium.freecodecamp.org/the-secret-to-being-a-top-developer-is-building-things-heres-a-list-of-fun-apps-to-build-aac61ac0736c)
* [6 Fun React Projects You Can Build Today](https://daveceddia.com/react-practice-projects/)
* [A list of project ideas from VanillaJS](https://learnvanillajs.com/projects/)
* [https://kopi.guide/](https://kopi.guide/)
* [https://react.rocks/](https://react.rocks/)
* [ReactRiot](https://www.reactriot.com/)
* [A list of open source apps built with React/Redux](https://github.com/markerikson/redux-ecosystem-links/blob/master/apps-and-examples.md)
* [11 React Examples](https://dev.to/drminnaar/11-react-examples-2e6d)
* [25 React Projects for learning React](http://sean-smith.me/assets/portfolio/25-react-projects/index.html)
* [React by Example](https://reactkungfu.com/showcases/)
* ["I Made This" on Reactflux](https://discordapp.com/channels/102860784329052160/312761588778139658)
* [http://builtwithreact.io/](http://builtwithreact.io/)
* [Popular Pens on CodePens](https://codepen.io/2018/popular/pens/)
* [Projects by General Assembly Students](https://gallery.generalassemb.ly/)
* [Projects by FullStack Academy Students](https://www.fullstackacademy.com/student-gallery)
* Build an application that you can talk to!
  * [react-speech-recognition](https://www.npmjs.com/package/react-speech-recognition)
  * [react-say](https://www.npmjs.com/package/react-say)
  * [compromise](http://compromise.cool/)
  * [wit.ai](https://wit.ai/)
  * [rasa](https://rasa.com/)
  * [ladybird](https://lyrebird.ai/)

## Sample Projects

* [https://cheeaun.github.io/repokemon/](https://cheeaun.github.io/repokemon/)
* [React-iTunes-search](https://github.com/LeoAJ/react-iTunes-search)
* Data Visualization
  * [Visualize related books using amazon API](https://anvaka.github.io/greview/hands-on-ml/1/)
  * [Interactive Infograph](https://www.smashingmagazine.com/2018/11/interactive-infographic-vue-js/)
  * [Explore Trees in Singapore](https://github.com/cheeaun/exploretrees-sg)
  * [Where to Mail](https://github.com/timmoti/postbox-hunter)
* [Build a web-based code editor](http://krasimirtsonev.com/blog/article/build-your-own-interactive-javascript-playground)
* [A website to track your running habit](https://github.com/newzealot/runninglog)
* [A website to collect vote](https://www.menti.com/)
* Build games
  * [Flatris](https://github.com/skidding/flatris)
  * [React Snake](https://github.com/taming-the-state-in-react/react-snake)
  * [Yet another Snake](https://github.com/briantjt/react-snake)
  * [Nokia Snake](https://github.com/Morgantheplant/nokia-snek)
  * [Chess Game](https://pusher.com/tutorials/realtime-chess-game-react)
  * [Maze Battles](http://www.mazebattles.com/)

## Resources

* [A long list of public APIs](https://github.com/toddmotto/public-apis)

