# Evaluation criteria checklist

Your projects will be evaluated and graded based on the following criteria:

- Project Workflow
  - [x] Use of user stories, wireframes, task tracking
- Technical Requirements
  - [x] Application of tools, techniques and practices learned in the current module
  - Automated tests
    - [x] all tests pass
    - [x] clear and correct test descriptions
    - [x] good test cases
  - Application of clean code practices covered in class
    - [x] Good formatting/indentation
    - [x] No syntax errors / warnings
    - [x] Clear and descriptive variable names
    - [x] Consistent formatting (e.g. semi-colons, double quotes, etc)
    - [x] Followed naming convention for variables
    - [x] Followed naming convention for files
    - [x] No unnecessary comments
    - [x] No duplication in code (i.e. code is DRY)
    - [x] Functions and classes are small and adhere to Single Responsibility Principle
  - Short and descriptive README
    - [x] What your project is about
    - [x] Link to a working app on heroku
    - [x] \[Optional\] Screenshots of your app
    - [x] How to clone and run app locally
    - [x] References:
      - [markdown cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet)
      - [what a good README looks like](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2)
- Project organization
	- [x] All required dependencies (e.g. jest) are included
- Deployment
  - [x] Continuous integration \(e.g. CircleCI, TravisCI\)
  - [x] Deployment of application to cloud provider of choice \(e.g. GitHub Pages, Heroku, AWS, etc\)

  