# Assignment Grading Rubric

## Assignment review rubric

Select the points are relevant for the assignment you're reviewing

* Code hygiene
  * [x] Good indentation
  * [x] Consistent formatting \(e.g. semi-colons, double quotes, etc\)
  * [x] No console.logs\(\)
  * [x] No unnecessary comments
  * [x] Followed naming convention for variables
  * [x] Followed naming convention for files
  * [x] Clear and descriptive variable names
  * [x] No duplication in code \(i.e. code is DRY\)
* Functions
  * [x] functions have a single return type
  * [x] functions do what they are supposed to do
* Classes
  * [x] classes adhere to Single Responsibility Principle
* React components
  * [x] The component's render\(\) or return statement should not be too big
  * [x] Each component should not be doing too many things
* Project organization
  * [x] All required dependencies \(e.g. jest\) are included
* Test cases
  * [x] all tests pass
  * [x] clear and correct test descriptions
  * [x] good test cases

