# What is ES6?

ECMAScript 6, also known as ECMAScript 2015 or ES6, is the version of the ECMAScript standard defined in year 2015. ES6 is a significant update to the JavaScript language, and the first update to the language since ES5 was standardized in 2009.

ES6 features offer solutions to many of the pains and quirks of working with JavaScript prior to ES6, and makes JavaScript a much nicer language to work with.

Are you confused by the terms like "ES6", "ECMAScript 2015"? Are they the same thing as "JavaScript"? Read on [article](https://medium.freecodecamp.org/whats-the-difference-between-javascript-and-ecmascript-cba48c73a2b5) to find more details.

Some of the features introduced in ES6 include:

* let and const
* new methods on String
* template strings
* arrow functions
* default function parameters
* destructuring
* rest and spread operator
* ES6 module system

Here is [the complete list of featured added since 2015](https://medium.freecodecamp.org/es5-to-esnext-heres-every-feature-added-to-javascript-since-2015-d0c255e13c6e)

## Resources

* [https://github.com/DrkSephy/es6-cheatsheet](https://github.com/DrkSephy/es6-cheatsheet)
* [https://kangax.github.io/compat-table/es6/](https://kangax.github.io/compat-table/es6/)
* [https://bytearcher.com/articles/how-to-check-if-node-implements-es6-language-feature/](https://bytearcher.com/articles/how-to-check-if-node-implements-es6-language-feature/)
* [The latest version of ECMAScript Standard](https://www.ecma-international.org/publications/standards/Ecma-262.htm)

## Assignments

### Assignment 1

Refactor past assignment to use ES6 syntax:

* [https://github.com/thoughtworks-jumpstart/javascript-basics](https://github.com/thoughtworks-jumpstart/javascript-basics)
* [https://github.com/thoughtworks-jumpstart/tdd-with-jest](https://github.com/thoughtworks-jumpstart/tdd-with-jest)
* [https://github.com/thoughtworks-jumpstart/dom-todo-list](https://github.com/thoughtworks-jumpstart/dom-todo-list) \(be careful with `this`! Remember when \(not\) to use ES6 arrow functions\)

