# JavaScript

## What is JavaScript?

JavaScript is a language that allows you to:

* write programs
* create applications \(server-side and client-side\)
* create dynamic content on the web
* manipulate web content \(e.g. animate images\)
* create games
* and much more!

## History

Brandan Eich created JavaScript in 10 days in May 1995, under duress and conflicting management imperatives—“make it look like Java,” “make it easy for beginners,” “make it control almost everything in the Netscape browser.”

Now, JavaScript has become the language of the web. To date, JavaScript is the only programming language with built-in support in all major web browsers for client-side application scripting. Moreover, in recent years, JavaScript has become a popular language for implementing server-side applications with the advent of the Node.js platform.

JavaScript has its idiosyncracies and gotchas, which we will discover over the course of working with it. But it can also be a very powerful tool in our toolkit, if we understand it and use it well.

Here is a good overview of the JavaScript landscape as of 2018:

* [Modern JavaScript Explained For Dinosaurs](https://medium.com/the-node-js-collection/modern-javascript-explained-for-dinosaurs-f695e9747b70)

## Tutorials

* [The Modern JavaScript Tutorial](http://javascript.info/)
* [Roadmap to Learn JavaScript](https://flaviocopes.com/javascript/)
* [JavaScript Concepts](https://github.com/divyanshu-rawat/JavaScript-Concepts)
* [33 concepts every JavaScript developer should know](https://github.com/leonardomso/33-js-concepts)
* [Learning ES6](https://github.com/ericdouglas/ES6-Learning)
* [JS Quick Hits](https://closebrace.com/categories/js-quick-hits)

## Books

* [Learn Enough JavaScript to be dangerous](https://www.learnenough.com/javascript-tutorial)
* [Eloquent JavaScript](http://eloquentjavascript.net/)
* [You Don't Know JS](https://github.com/getify/You-Dont-Know-JS)

## Online Courses

* [Modern JavaScript From The Beginning](https://www.udemy.com/modern-javascript-from-the-beginning/)
* [JavaScript: Understanding the Weird Parts](https://www.udemy.com/understand-javascript/)

## References

* [The Complete JavaScript Handbook](https://medium.freecodecamp.org/the-complete-javascript-handbook-f26b2c71719c)
* [JavaScript concepts with code](https://github.com/vasanthk/js-bits)
* [ES6 Features](https://github.com/lukehoban/es6features)
* [ES6 Feature with Examples](http://es6-features.org/)
* [ES6 Cheat Sheet](https://github.com/DrkSephy/es6-cheatsheet)
* [Minimalist examples of ES6 functionalities](https://github.com/hemanth/paws-on-es6)
* [ES6 Equivalents in ES5](https://github.com/addyosmani/es6-equivalents-in-es5)
* [JavaScript Cheat Sheet](https://github.com/krishnr/JavaScript-cheat-sheet)
* [MDN Docs explorer](http://devdocs.io/)
* [Mozilla Developers' Network \(MDN\) JavaScript documentation](https://developer.mozilla.org/en-US/docs/Learn/JavaScript/First_steps/What_is_JavaScript)
* [Awesome JavaScript learning resources](https://github.com/micromata/awesome-javascript-learning)
* [Modern JS Cheat Sheet](https://mbeaudru.github.io/modern-js-cheatsheet/)
* [JavaScript Garden](http://bonsaiden.github.io/JavaScript-Garden/)
* [A useful list of must-watch talks about JavaScript](https://github.com/AllThingsSmitty/must-watch-javascript)

## Assignments

* [JavaScript basics](https://github.com/thoughtworks-jumpstart/javascript-basics)
* [Fun with classes](https://github.com/thoughtworks-jumpstart/javascript-classes)
* [Fun with higher order functions](https://github.com/thoughtworks-jumpstart/higher-order-functions-exercises)

