# Independent learning

One of the most important things that you can learn from JumpStart is learning how to learn. In our lifetime as developers, we have no choice but to learn new languages, new frameworks \(it's what makes our job so exciting!\)

So, this week - your mission is to learn a new programming language. On Friday, you will give your classmates a crash course on your \(pair/team/group's\) programming language of choice.

Some recommended languages:

* Python
* Java

### Learning checklist \(also presentation outline\)

* basic syntax \(i.e. "how do i create..."\)
  * variables
  * primitives \(e.g. strings, integers, floats\)
  * conditional statements
  * for loops
  * functions
  * classes
* code organisation
  * how do i import/export variables between files?
  * how do i install project dependencies \(i.e. what's the equivalent of npm, package.json and node\_modules?\)
  * how do i execute 1 file/program?
* IDE setup
  * what's a good IDE?
  * how do i configure the IDE to work well?
  * what are some useful plugins \(e.g. keyboard shortcuts, linting, etc\)
* do 2-3 simple katas in this language
  * www.codewars.com offer katas in many languages
* build a simple program with the language. some suggestions:
  * build a 'hello world' web api 
  * redo an assignment in this language \(e.g. mars rover\)
* unit testing
  * what unit test runner can i use?
  * how do i write 1 unit test?
* programming paradigms
  * how do you practise OOP in the language?
  * how do you practise functional programming in the language?
* any other cool stuff you learned/built 

### Tips

* don't blindly copy and paste
* focus on building something very simple. your goal is to learn a new language \(through building something\). your goal is not to build something
* don't spend too much time meta-reading \(i.e. reading about what you should read\). google for a good 'getting started' guide and just start by the end of Monday. for each getting started guide, there are 10-100s of other guides/listicles/books. at the introductory level, they probably cover the same contents. just pick a good one and start coding!
* if you get stuck on the setup/configuration of programs/languages, you can use an online editor \(e.g. [repl.it](http://repl.it/)\) temporarily to try out code snippets
* pair / share. ask questions. share understanding.

This week, there will be no hand-holding, no answers from us. Have fun!

## Resources

### Python 3

* [Python 101](http://www.learnpython.org/en/Welcome)
* Installing Python [Mac](http://docs.python-guide.org/en/latest/starting/install3/osx/) and [Windows](https://docs.python.org/3/using/windows.html)
* [Python 3 docs](https://docs.python.org/3/)
* [VS Code IDE configuration for Python](https://code.visualstudio.com/docs/languages/python)
* [Listicle of learning resources for Python](https://dev.to/jessicagarson/resources-for-learning-python-hd6)
* Dependency management
  * [dependency management with `pipenv`](https://realpython.com/pipenv-guide/)
  * [dependency managemnet with `pipenv`, `pipsi` and `pyenv`](https://jacobian.org/writing/python-environment-2018/)
* [Unit testing with `unittest`](https://docs.python.org/3/library/unittest.html)
  * [Other unit testing libraries](http://docs.python-guide.org/en/latest/writing/tests/)

### Java

* [Java 101](https://beginnersbook.com/2013/05/java-introduction/)
* [Installing Java](http://davidcai.github.io/blog/posts/install-multiple-jdk-on-mac/)
* [IDE](https://www.jetbrains.com/idea/)
  * [Dependency management with gradle 101](https://www.jetbrains.com/help/idea/getting-started-with-gradle.html)
  * [Keyboard shortcuts reference](https://resources.jetbrains.com/storage/products/intellij-idea/docs/IntelliJIDEA_ReferenceCard.pdf)
  * [Keyboard shortcuts \(2-hour course\)](https://www.udemy.com/intellij-idea-secrets-double-your-coding-speed-in-2-hours/) \(**Highly recommended**. you can pay and claim with [SkillsFuture](https://support.udemy.com/hc/en-us/articles/115002373787-The-SkillsFuture-Credit-Program-Commonly-Asked-Questions)\)
    * [Different shortcut keymaps](https://stackoverflow.com/questions/19596766/whats-the-difference-between-keymaps-mac-os-x-and-mac-os-x-10-5)
  * [42 IntelliJ IDEA tips and tricks](https://www.youtube.com/watch?v=eq3KiAH4IBI)
  * [Configuring your IDE](https://www.jetbrains.com/help/idea/configuring-project-and-ide-settings.html)
* [Unit testing with JUnit](https://junit.org/junit5/docs/current/user-guide/#overview)

