# Goals and objectives of ThoughtWorks JumpStart

The Pragmatic Programmers series on Pragmatic Thinking and Learning suggests setting SMART (Specific, Measurable, Achievable, Relevant, and Time-boxed) objectives as a tool for effective learning.

Here is an attempt to define the goal(s) and objectives of our program.

Unique selling point of JumpStart:
- hands-on experience
- best agile engineering practices
- environment for growth and continuous growth of trainee in software industry

Goal: **Guide JumpStarters on the journey towards software mastery**

Objectives:

1) Learn how to learn independently and effectively
- [ ] continuous learning
- [ ] how to read docs
- [ ] how to debug effectively

2) Get a working knowledge of the following topics
- Programming language
	- [ ] basic javascript constructs (e.g. variables, functions, objects, classes, etc)
	- [ ] advanced javascript constructs (closures, callbacks, bind, call, apply, etc)
	- [ ] ES6 basics
- Testing
	- [ ] TDD
	- [ ] mocking and stubbing
	- [ ] the testing pyramid
- Version control
	- [ ] git
	- [ ] trunk-based development
- Object oriented programming
	- [ ] SOLID principles
	- [ ] Beck's 4 rules of simple design
- Clean code
	- [ ] how to identify code smells
	- [ ] some refactoring techniques
- Functional programming
	- [ ] basic principles
	- [ ] basic techniques (e.g. recursion, map, reduce, filter, currying)
- Front-end web development
	- [ ] HTML and CSS
	- [ ] DOM manipulation
	- [ ] React
- Full stack web development
	- [ ] How the web works
	- [ ] Application layers (DB, Model, View, Controller)
	- [ ] how to consume an API
	- [ ] how to build a CRUD web API
	- [ ] how to build a CRUD / full-stack web application
- Security
	- [ ] High-level threat modeling process
	- [ ] OWASP Top 10
- DevOps
	- [ ] The Three Ways: the principles underpinning DevOps
	- [ ] How to create prod-like environments
	- DevOps toolchain
		- [ ] Unix shell basics
		- [ ] Ansible
		- [ ] GoCD
		- [ ] Docker

3) Learn and apply main agile methods
- [ ] pair programming
- [ ] cross functional teams
- [ ] experience design / user testing
- [ ] user stories
- [ ] CI/CD pipeline
- [ ] inception process
- [ ] feedback
- [ ] retros

4) Additional modules
- Design patterns
	- [ ] value objects
	- [ ] command pattern
	- [ ] observer pattern
	- [ ] strategy pattern
- [ ] data structures
