# Lab 6: Add feature to create a new restaurant in the Admin page

## Lab 6: Add feature to create a new restaurant in the Admin page

In this lab you are required to create a `Create New` button in the Admin page

1. When the Admin clicks on this button the page will navigate to a form to add a new restaurant
2. After form is filled, and the `Save` button is clicked, the page will navigate back to the restaurant table
3. The new restaurant should now be in the list

### Feature details

* Navigate to the food-app project directory on your computer
* checkout to the lab 6 branch

```text
  git checkout lab6
  git branch
```

### Step 1:

* Create an `Create New` button and place it on the top right hand side below the NavBar
* Link the `Create New` button to the Restaurant form page with the route `restaurants/new`
* Create route in App.js for `restaurants/new` and render the RestaurantForm

### Step 2:

* Create a RestaurantForm react component
  * in src/components/RestaurantForm/RestaurantForm.jsx
  * this component will contain all the form fields required for a new restaurant
  * Place the heading `Restaurant Form` in this component
* Ensure that the button navigates to the form when you click on it

### Step 3:

* Add the form fields to the RestaurantForm
  * use a Select field for Cuisine attribute
  * use Text fields for all other attributes
  * and will have `Save` button at the bottom

### Step 4:

* In order to avoid too complex a `render()` in RestaurantForm we need to extract the form fields to different components
  * Create a Input react component
    * in src/components/common/Input/Input.jsx
    * this component will render a text input or number input
  * Create a SelectInput component
    * in src/components/common/SelectInput/SelectInput.jsx
    * this component will render a select input

### Step 5:

* Create a form submit handler and link it to the `Save` button
* in the form handler you can call `saveRestaurant()` from RestaurantService to save the new restaurant
* Note: you are not required to do form validation at this stage. Assume that all input will be valid data.

### Expected Output

This screenshot is a sample of the expected output

![Create New restaurant button on the Admin page](../../../.gitbook/assets/lab6-output-1%20%281%29.png)

![Create new restaurant form](../../../.gitbook/assets/lab6-output-2%20%281%29.png)

![Options in the cuisine select field](../../../.gitbook/assets/lab6-output-3.png)

![Restaurant table now contains the newly created restaurant](../../../.gitbook/assets/lab6-output-4%20%281%29.png)

### Hints

* Use the [bootstrap form-group](https://getbootstrap.com/docs/4.1/components/forms/#overview) style for the form

### Solution

* After you have completed Lab 6, please commit all your work to the `lab6` branch
* You may optionally install the plugin **Git History Diff** for viewing the difference between git branches. This will allow you to easily compare your work with the sample solution
* [https://marketplace.visualstudio.com/items?itemName=huizhou.githd](https://marketplace.visualstudio.com/items?itemName=huizhou.githd)
* Next checkout to the solution branch and we will now walk through the sample solution

```text
git checkout lab6-demo
```

* To view the difference between your work and the sample solution go to the VS Code file explorer, right click your folder and select `GitHD: View Folder Diff` and select compare with `lab6` branch
* The diff sidebar will popup and you can click on the files to view the difference between your work and the sample solution.
* When viewing the diff you can temporarily toggle the sidebar with `cmd + B` to hide it.

### Testing

* Next we will discuss how to test the feature with react testing library

## Demo

* After the lab we will have a code-along of how to make use of a third party library `simple-react-timefield library` to improve the handling of time input \(to not allow entering of invalid time\)
* checkout to the lab 6 demo branch

```text
  git checkout lab6-demo
  git branch
```

* We will first install the library

```text
npm install simple-react-timefield
```

* Next we will create a new component `TimeInput` which will use this library to create an input that only allows the user to input a valid time
* In the last part we will use the TimeInput in the RestaurantForm

