# React Performance Tuning

## React Profiler

In React 16.5.0 release, a new profiler tool is included in the React Dev Tools. You can checkout the tutorials below to see how you can use it:

* [Introducing the React Profiler](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)
* [Use the New Profiler in React Developer Tools to Generate Flame Charts and Interactions](https://elijahmanor.com/react-devtools-profiler/)
* [Using the React DevTools Profiler to Diagnose React App Performance Issues](https://www.netlify.com/blog/2018/08/29/using-the-react-devtools-profiler-to-diagnose-react-app-performance-issues/)

## Checkout reasons for update

If you would like to find out if some React component is re-rendered unnecessarily, you can also use this tool called [Why Did You Update](https://github.com/maicki/why-did-you-update)

## Resources

* [A checklist for eliminating common React performance issues](https://logrocket-blog.ghost.io/death-by-a-thousand-cuts-a-checklist-for-eliminating-common-react-performance-issues/)
* [Profiling React Components with the User Timing API](https://www.telerik.com/blogs/profiling-react-components-with-the-user-timing-api)
* [Optimizing React: Virtual DOM explained](https://evilmartians.com/chronicles/optimizing-react-virtual-dom-explained)

