# CSS

**C** ascading **S** tyle **S** heets \(CSS\) power the colors, fonts, layout and animations that you see in your browser. In the next few pages, we'll learn how to get good at it.

## An overview of CSS history

If you are new to CSS, you can read the article blow to get an overview:

* [Modern CSS Explained For Dinosaurs](https://medium.com/actualize-network/modern-css-explained-for-dinosaurs-5226febe3525)

## How to Learn CSS

You don’t need to commit to memorizing every CSS Property and Value, as there are good places to look them up. There are some fundamental things, however, which will make CSS much easier for you to use. [This article](https://www.smashingmagazine.com/2019/01/how-to-learn-css/) aims to guide you along your path of learning CSS.

## CSS Tutorial

We will briefly cover the most important topics in this material, however, if you have more time to go-through a tutorial that covers the topics thoroughly, I can recommend the two below:

* [Introduction to CSS](https://developer.mozilla.org/en-US/docs/Learn/CSS/Introduction_to_CSS)
* [HTML & CSS is Hard \(and It Shouldn't Be\)](https://internetingishard.com/html-and-css/)

## CSS Reference

Bookmark the link below, you need to refer to it frequently.

* [MDN CSS Reference](https://developer.mozilla.org/en-US/docs/Web/CSS/Reference)
* [Codrops CSS Reference](https://tympanus.net/codrops/css_reference/)

## Resources:

* Beginner materials:
  * [CSS Basics](https://developer.mozilla.org/en-US/docs/Learn/Getting_started_with_the_web/CSS_basics)
  * [CSS Fundamental](http://interactivepython.org/runestone/static/webfundamentals/index.html#cascading-style-sheets)
  * [The CSS Guide](https://flaviocopes.com/css/)
  * [CSS Tricks](https://css-tricks.com/guides/beginner/)
* Intermediate materials:
  * [A to Z CSS](https://www.sitepoint.com/tag/atoz-css/)
  * [Learn CSS Layout](http://learnlayout.com/)
  * [All about floats](https://css-tricks.com/all-about-floats/)
  * [MDN CSS Layouts](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout)
* Samples/Galleries
  * [HTML/CSS - Katas](https://codepen.io/collection/ABLwQb/2/)
  * [CSS Zen Garden](http://www.csszengarden.com/)
  * [CSS Deck](http://cssdeck.com/)
  * [Envato](https://elements.envato.com/)
  * [CSS Tricks Gallery](https://css-tricks.com/gallery/)
  * [30 Seconds of CSS](https://atomiks.github.io/30-seconds-of-css/)
  * [CSS Playgrounds](https://css-playground.com/)
* Useful Tools
  * [Can I Use](https://caniuse.com/)
  * [CSS Specificity calculator](https://developer.mozilla.org/en-US/docs/Web/CSS/Specificity)
* CSS Property Reference
  * [CSS Reference](https://tympanus.net/codrops/css_reference/)
  * [A Visual Guide to CSS](https://cssreference.io/)
* [Useful talks on CSS](https://github.com/AllThingsSmitty/must-watch-css)

## Labs

* [Recreate Blog article Page](https://github.com/thoughtworks-jumpstart/blog-article-css)
* [Recreate Apple Landing Page](https://github.com/thoughtworks-jumpstart/apple-css-lab)
* [CSS Diner](https://flukeout.github.io/)

## Additional practice

* [CSS Exercise on W3Schools](https://www.w3schools.com/css/exercise.asp?filename=exercise_howto1)
* [CSS Kata](https://github.com/georgenorman/css-kata)
* [A set of simple html and css exercises](https://github.com/ashleygwilliams/introHTMLCSS)
* [Step by step creation of a website](https://openclassrooms.com/courses/build-your-website-with-html5-and-css3/practical-exercise-step-by-step-creation-of-a-website)
* Play with [the CSS rules to simulate instagram filters](https://github.com/picturepan2/instagram.css)

