# VS Code Shortcuts

![.](../.gitbook/assets/keyboard_shortcuts_xkcd.png)

## Learning checklist

\(Open up one of your past javascript assignment in VS Code to try the following shortcuts\)

* How to open the command palette \(shift + cmd + p or F1\)
* How to find out keyboard shortcuts on the fly
  * via 'keyboard shortcuts' shortcut
  * via 'command palette' shortcut
* Learn at least 15 shortcuts
  * For interacting with files
    * go to file
    * rename file
    * delete file
  * For interacting with code
    * select next occurrence of selection \(multi-cursor\)
    * move/copy line\(s\) up/down
    * format code
    * go to definition \(+ open definition to the side\)
    * trigger suggestions
    * trigger parameter hints
    * expand/shrink selection
    * go to symbol \(e.g. class name, function name\)
    * how to split screen
  * For interacting with code editor
    * Toggle sidebar visibility
    * Show Explorer / Search / Debug
    * Toggle terminal
    * User settings/preferences
    * Toggle full screen
    * zoom in/out
* You can customize your keybindings

## Resources

### Enable automatic JavaScript type checking

VS Code allows you to leverage some of TypeScript's advanced type checking and error reporting functionality in regular JavaScript files. This is a great way to catch common programming mistakes. These type checks also enable some exciting Quick Fixes for JavaScript, including Add missing import and Add missing property.

This is disabled by default. If you like the feature, read [the documentation](https://code.visualstudio.com/docs/languages/javascript#_type-checking) on how to enable it per-file, per-project, or always.

### Recommended reading

* [How to customize your keybindings](https://code.visualstudio.com/docs/getstarted/keybindings)
* [VS Code tips and tricks](https://github.com/Microsoft/vscode-tips-and-tricks)

### References

* Keyboard shortcuts for [Windows](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-windows.pdf), [Mac](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-macos.pdf), [Linux](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-linux.pdf)
* [VS Code Can Do That?!](https://vscodecandothat.com/)
* [VS Code Rocks](https://vscode.rocks/)

### Lab

Choose a previous assignments, try to edit the codes without mouse.

