# Technical Interview

## Sample Questions

### Deployment Automation / DevOps

* How did you use Circle CI in your last project?
* Can you describe your build pipeline?
* How did you use Heroku/Netlify to deploy your application? Why did you choose that?

### Git

* How do you handle git merge conflict?

### Testing

* What is TDD? What benefit do we get from it?
* How do you use supertest to test your Express API?
* How do you use Cypress to write UI tests?
* Do you know what is test-pyramid? Why is it more costly to maintain UI test or integration test?
* How do you write unit test for react components? Why do you use react-testing-library instead of enzyme?

### Agile Practices

* What Agile practices do you practice in your project? What benefit do you get from each practice?
* What are user stories? How to write good user stories?
* What is pair programming about?

### JavaScript

* What are the new features in ES6?
* What’s the difference let and var?
* How to understand ‘this’ in JavaScript?
* How to use arrow functions?
* What is the promise? How to handle exceptions from promise?
* What’s async/await? Compare it to Promise.

### React

* Have you heard about latest React feature \(e.g. React hooks\)
* What’s the difference between React and other frameworks like Veu/Angular?
* What are the basic concepts in React?
  * Component. What’s a component?
  * When do you write component as a function and when do you write it as a class? What’s the difference?
  * Props
  * State
  * What is JSX?
* How to manage state in React?
  * Local State
  * Context
  * Redux
* What are Higher Order Components?
* List a few life-cycle methods in React

### Authentication

* How do you handle authentication with JWT?
* Where to store JWT token on the client side?

### Database?

* Why did you use MongoDB in the project instead of a relational database?
* What are the differences between MongoDB and PostgreSQL database?
* What library did you use to access the MongoDB/PostgreSQL?

### Questions to test your passion/interests in technology

* What motivate you to become a developer?
* Why did you decide to change your career and join JumpStart?
* What's your career plan after this?
* What's your dream job?
* What technical books did you read recently?
* What technical websites/blogs do you follow?
* Do you have any pet projects?
* What do you do during weekends?

### Questions to test your learning capabilities

* Tell me what you learned in JumpStart program
* Tell me how would you pick up a new language/library that is not taught in JumpStart?
* If you join a new team, what would you do to quickly get up to full speed?
* If you are in a team that nobody coach/mentor you, what would you do?

### Team work

* Did you have any conflict with your previous team mates? If so, how did you resolve that?
* Was there a situation when you and your colleagues had different solution on the same problem? How did you arrive at one solution?

## Resources

### Interview Questions

* [50+ Data Structure and Algorithms Interview Questions for Programmers](https://hackernoon.com/50-data-structure-and-algorithms-interview-questions-for-programmers-b4b1ac61f5b0)
* [Frontend Developer Interview Questions](https://h5bp.github.io/Front-end-Developer-Interview-Questions/)
* [Awesome list of lists of interview questions](https://github.com/MaximAbramchuck/awesome-interview-questions)
* [30 seconds of interviews](https://30secondsofinterviews.org/)
* [CS Knowledge Map](https://github.com/InterviewMap/CS-Interview-Knowledge-Map/blob/master/README-EN.md)
* [Interactive Coding Challenges \(in Python\)](https://github.com/donnemartin/interactive-coding-challenges)

### Learning Materials

* [Frontend Interview Handbook](https://github.com/yangshun/front-end-interview-handbook)
* [Tech Interview Handbook](https://github.com/yangshun/tech-interview-handbook)
* [Frontend Dev Bookmarks](https://github.com/dypsilon/frontend-dev-bookmarks)
* [System Design Primer](https://github.com/donnemartin/system-design-primer)
* [Common Algorithms Implemented in JavaScript](https://github.com/trekhleb/javascript-algorithms)
* [Coding Interview University](https://github.com/jwasham/coding-interview-university)
* [Crack the Coding Interview](http://www.crackingthecodinginterview.com/)

### Interview Preparation Courses/Websites

* [Coderust 3.0: Faster Coding Interview Preparation](https://www.educative.io/collection/5642554087309312/5679846214598656)
* [Hired in Tech](https://www.hiredintech.com/)
* [Interview Cake](https://www.interviewcake.com/)
* [Interview Bit](https://www.interviewbit.com/)
* [Pramp](https://www.pramp.com/#/)

### Tips for preparing technical interview

* [The ultimate guide to preparing for the coding interview](https://medium.freecodecamp.org/the-ultimate-guide-to-preparing-for-the-coding-interview-183251ee36c9)
* [I spent 3 months applying to jobs after a coding bootcamp. Here’s what I learned](https://medium.freecodecamp.org/5-key-learnings-from-the-post-bootcamp-job-search-9a07468d2331)
* [Reddit Discussion: How to Prepare for Tech Interviews](https://www.reddit.com/r/cscareerquestions/comments/1jov24/heres_how_to_prepare_for_tech_interviews/)
* [How to Build and Leverage Your Network to Land Your First Technical Interview](https://www.fullstackinterviewing.com/2018/03/20/how-to-build-and-leverage-your-network-to-land-your-first-technical-interview.html)
* [5 Mistakes You're Making In Your Technical Interviews & How To Avoid Them](https://dev.to/emmawedekind/5-mistakes-youre-making-in-your-technical-interviews--how-to-avoid-them-465e)

