# Job Hunt preparation

## Update your resume

To start with, you need to update your resume with your latest and relevant skillset. There are many tips for writing a good resume, here is [a good article](https://medium.freecodecamp.org/how-to-write-a-great-resume-for-software-engineers-75d514dd8322)

## Practical tips for the job hunt:

We collected some feedback from the first batch of jumpstart trainees on what advice they'd give their juniors on the job hunt, their suggestions can be summed up in **3Ps**:

* **P**ortfolio projects
* **P**ractice katas, TDD and other things taught in class
* **P**ractice for your interviews

To flesh it out further, you should:

1. **Update your portfolio page and LinkedIn profile, and make it a good one.** Many employers and recruitment folks will have their first impression of you via your portfolio page and LinkedIn profile. Make sure it's a good one with short/one-glance view of your projects \(use screenshots/gifs if possible!\) and skills \(programming languages, frameworks, agile methodologies, etc\)
2. **Go to** [**meetups and events**](https://webuild.sg/) **that interest you.** I've met folks who have gotten jobs through these platforms. Plus there's free food and awesome talks!
3. **Build your own side projects.** This will help build up your portfolio, and it will speak volumes for you when employers are assessing candidates. Had a brainwave while sitting on the toilet bowl? Write it down! See a problem which you think can be solved by software? Put on your agile development hat, wireframe it and build it in a weekend! I find that two things help: set deadlines for yourself, and do not overthink it. Build MVP first and then iterate from there. It's better to have several interesting projects in the pipeline, even if they are half-complete, rather than one mega perfect project that never got started.
4. **Get good at technical interviews.** Based on feedback from the first batch of jumpstart, they typically encounter these types of technical interviews:

   1. coding katas \(like in codewars\)
   2. build an app \(e.g. in React, or Express, or a totally new framework\)
   3. whiteboarding: programming katas
   4. whiteboarding: object-oriented domain modelling

   Note: Generally, they are not looking for complete or perfect textbook answers. They are assessing your thought process, how you approach a problem, and how you figure out things which you may not know. These articles provide some interview tips:

   * [How to Impress in a Junior Developer Job Interview](https://medium.com/@CodementorIO/how-to-impress-in-a-junior-developer-job-interview-2d2fb325a66c#.2mskcv53j)
   * [Q&A on frequently asked interview questions on JavaScript](https://github.com/ggomaeng/awesome-js)
   * [Cracking the Coding Interview](https://robot.bolink.org/ebooks/Cracking%20the%20Coding%20Interview%20-%20150%20Programming%20Interview%20Questions%20and%20Solutions%204e%20Small.pdf) \(see pages 28-44\)
   * [JavaScript interview prep](https://github.com/ajzawawi/js-interview-prep)

5. **Practice TDD.** This will help you get comfortable and help you shine in technical interviews. How? Go to your programming challenge webpage of choice \(Codewars, HackerRank, Codility\), copy and paste the challenge in your code editor, and write your own tests. It is a fun and rewarding experience. It's like doing crossword or sudoku puzzles, but for programmers. If you run out of tests to do, you can even practice TDD on [regular mathematical puzzles](https://projecteuler.net/) \(e.g. write a function that lists fibonacci numbers up to 1,000,000\).

Past JumpStart! graduates shared that preparation on the following topics helped them during the interview:

* Katas \(e.g. Codewars\) \(explaining code and the thought process\)
* TDD
* Data structures
* Read up and practice on designing common domain modelling questions \(e.g. designing a X system\)
* Knowledge of Rest API
* How to deploy applications
* Practice/mock interviews
* Pair programming
* Researching on company history & business operations, and find out the tech skills they require from candidate and anticipate the question that will be asked.

## More important stuff / tips

1. **Accept that you'll never know enough \(a.k.a. the imposter syndrome\).** The day that you think you know enough is the day that you stop learning. Saying "I don't know" and "I don't understand" is a good thing. It's great. It's essential. It doesn't mean "I'm stupid" or "I'm inexperienced and not worth talking to about this." It means that you're opening yourself up to learning or understanding it. I've learned enough to know how much I don't know. When I was starting out, I thought I knew so much. \(Gabe Hollombe, Pivotal Labs\)
2. **Believe in yourself.** You know more about javascript, ruby, html5, css, front-end frameworks than 95% of the world! You now have skills that will be valuable to businesses, decision makers, NGOs, etc. Hone those skills!
3. **Always be learning.** For me, this is the best part about being a programmer. You get to continually learn interesting ways to build things. You have access to open source libraries, documentation, stack overflow, meetups and [awesome conferences and talks](https://engineers.sg/). Pick something, prioritise them and master it.

For more tips on software development, check out this [awesome guide](https://docs.google.com/document/d/1tMgtfyHz31x2Mtnp9TvlpE2V1S8iQ32nNx-NxJIIpkI/edit) by Gabe Hollombe

## Jobs boards:

* [https://www.techinasia.com/jobs](https://www.techinasia.com/jobs)
* [https://e27.co/jobs](https://e27.co/jobs)

## Other useful resources:

* [A retrospective on my tech job search](https://blog.safia.rocks/post/170800851750)
* [A list of tech companies in Singapore](http://walkabout.sg/)
* [Recognizing impostor syndrome and fixing it before it messes up your coding interview](https://dev.to/interviewcake/recognizing-impostor-syndrome-and-fixing-it-before-it-messes-up-your-coding-interview-2j12)
* [How to Prepare for Behavioral Based Job Interview Questions](https://www.thebalancecareers.com/behavioral-job-interview-questions-2059620)
* [What are system design questions?](https://www.hiredintech.com/classrooms/system-design/lesson/52)
* [How I interviewed for 5 top companies in 5 days and got job offers from all of them](https://www.techinasia.com/talk/5-companines-5-days-5-offers)
* [http://blog.gainlo.co/](http://blog.gainlo.co/)

